/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.data;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class FilteringClassLikeInfo
implements JetClassLikeInfo {
    private final JetClassLikeInfo delegate;
    private final NotNullLazyValue<List<JetDeclaration>> filteredDeclarations;

    public FilteringClassLikeInfo(@NotNull StorageManager storageManager, final @NotNull JetClassLikeInfo delegate, final @NotNull Predicate<? super JetDeclaration> declarationFilter) {
        this.delegate = delegate;
        this.filteredDeclarations = storageManager.createLazyValue(new Computable<List<JetDeclaration>>(){

            @Override
            public List<JetDeclaration> compute() {
                return Lists.newArrayList(Collections2.filter(delegate.getDeclarations(), declarationFilter));
            }
        });
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        return this.delegate.getContainingPackageFqName();
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        return this.delegate.getDelegationSpecifiers();
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return this.delegate.getModifierList();
    }

    @Override
    @Nullable
    public JetClassObject getClassObject() {
        return this.delegate.getClassObject();
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        return this.delegate.getScopeAnchor();
    }

    @Override
    @Nullable
    public JetClassOrObject getCorrespondingClassOrObject() {
        return this.delegate.getCorrespondingClassOrObject();
    }

    @Override
    @NotNull
    public List<JetTypeParameter> getTypeParameters() {
        return this.delegate.getTypeParameters();
    }

    @Override
    @NotNull
    public List<? extends JetParameter> getPrimaryConstructorParameters() {
        return this.delegate.getPrimaryConstructorParameters();
    }

    @Override
    @NotNull
    public ClassKind getClassKind() {
        return this.delegate.getClassKind();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        return this.filteredDeclarations.compute();
    }

    public String toString() {
        return "filtering " + this.delegate.toString();
    }
}

