/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaValueParameterImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaElementCollectionFromPsiArrayUtil {
    private JavaElementCollectionFromPsiArrayUtil() {
    }

    @NotNull
    private static <Psi, Java> Collection<Java> convert(@NotNull Psi[] elements, @NotNull Factory<Psi, Java> factory) {
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Java> result = new ArrayList<Java>(elements.length);
        for (Psi element : elements) {
            result.add(factory.create(element));
        }
        return result;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull PsiClass[] classes) {
        return JavaElementCollectionFromPsiArrayUtil.convert(classes, Factories.CLASSES);
    }

    @NotNull
    public static Collection<JavaPackage> packages(@NotNull PsiPackage[] packages) {
        return JavaElementCollectionFromPsiArrayUtil.convert(packages, Factories.PACKAGES);
    }

    @NotNull
    public static Collection<JavaMethod> methods(@NotNull PsiMethod[] methods) {
        return JavaElementCollectionFromPsiArrayUtil.convert(methods, Factories.METHODS);
    }

    @NotNull
    public static Collection<JavaField> fields(@NotNull PsiField[] fields) {
        return JavaElementCollectionFromPsiArrayUtil.convert(fields, Factories.FIELDS);
    }

    @NotNull
    public static Collection<JavaValueParameter> valueParameters(@NotNull PsiParameter[] parameters) {
        return JavaElementCollectionFromPsiArrayUtil.convert(parameters, Factories.VALUE_PARAMETERS);
    }

    @NotNull
    public static Collection<JavaTypeParameter> typeParameters(@NotNull PsiTypeParameter[] typeParameters) {
        return JavaElementCollectionFromPsiArrayUtil.convert(typeParameters, Factories.TYPE_PARAMETERS);
    }

    @NotNull
    public static Collection<JavaType> types(@NotNull PsiType[] types) {
        return JavaElementCollectionFromPsiArrayUtil.convert(types, Factories.TYPES);
    }

    @NotNull
    public static Collection<JavaClassifierType> classifierTypes(@NotNull PsiClassType[] classTypes) {
        return JavaElementCollectionFromPsiArrayUtil.convert(classTypes, Factories.CLASSIFIER_TYPES);
    }

    @NotNull
    public static Collection<JavaAnnotation> annotations(@NotNull PsiAnnotation[] annotations) {
        return JavaElementCollectionFromPsiArrayUtil.convert(annotations, Factories.ANNOTATIONS);
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namelessAnnotationArguments(@NotNull PsiAnnotationMemberValue[] memberValues) {
        return JavaElementCollectionFromPsiArrayUtil.convert(memberValues, Factories.NAMELESS_ANNOTATION_ARGUMENTS);
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namedAnnotationArguments(@NotNull PsiNameValuePair[] nameValuePairs) {
        return JavaElementCollectionFromPsiArrayUtil.convert(nameValuePairs, Factories.NAMED_ANNOTATION_ARGUMENTS);
    }

    private static class Factories {
        private static final Factory<PsiClass, JavaClassImpl> CLASSES = new Factory<PsiClass, JavaClassImpl>(){

            @Override
            @NotNull
            public JavaClassImpl create(@NotNull PsiClass psiClass) {
                return new JavaClassImpl(psiClass);
            }
        };
        private static final Factory<PsiPackage, JavaPackageImpl> PACKAGES = new Factory<PsiPackage, JavaPackageImpl>(){

            @Override
            @NotNull
            public JavaPackageImpl create(@NotNull PsiPackage psiPackage) {
                return new JavaPackageImpl(psiPackage);
            }
        };
        private static final Factory<PsiMethod, JavaMethodImpl> METHODS = new Factory<PsiMethod, JavaMethodImpl>(){

            @Override
            @NotNull
            public JavaMethodImpl create(@NotNull PsiMethod psiMethod) {
                return new JavaMethodImpl(psiMethod);
            }
        };
        private static final Factory<PsiField, JavaFieldImpl> FIELDS = new Factory<PsiField, JavaFieldImpl>(){

            @Override
            @NotNull
            public JavaFieldImpl create(@NotNull PsiField psiField) {
                return new JavaFieldImpl(psiField);
            }
        };
        private static final Factory<PsiParameter, JavaValueParameterImpl> VALUE_PARAMETERS = new Factory<PsiParameter, JavaValueParameterImpl>(){

            @Override
            @NotNull
            public JavaValueParameterImpl create(@NotNull PsiParameter psiParameter) {
                return new JavaValueParameterImpl(psiParameter);
            }
        };
        private static final Factory<PsiTypeParameter, JavaTypeParameterImpl> TYPE_PARAMETERS = new Factory<PsiTypeParameter, JavaTypeParameterImpl>(){

            @Override
            @NotNull
            public JavaTypeParameterImpl create(@NotNull PsiTypeParameter psiTypeParameter) {
                return new JavaTypeParameterImpl(psiTypeParameter);
            }
        };
        private static final Factory<PsiType, JavaTypeImpl<?>> TYPES = new Factory<PsiType, JavaTypeImpl<?>>(){

            @Override
            @NotNull
            public JavaTypeImpl<?> create(@NotNull PsiType psiType) {
                return JavaTypeImpl.create(psiType);
            }
        };
        private static final Factory<PsiClassType, JavaClassifierTypeImpl> CLASSIFIER_TYPES = new Factory<PsiClassType, JavaClassifierTypeImpl>(){

            @Override
            @NotNull
            public JavaClassifierTypeImpl create(@NotNull PsiClassType psiClassType) {
                return new JavaClassifierTypeImpl(psiClassType);
            }
        };
        private static final Factory<PsiAnnotation, JavaAnnotationImpl> ANNOTATIONS = new Factory<PsiAnnotation, JavaAnnotationImpl>(){

            @Override
            @NotNull
            public JavaAnnotationImpl create(@NotNull PsiAnnotation psiAnnotation) {
                return new JavaAnnotationImpl(psiAnnotation);
            }
        };
        private static final Factory<PsiAnnotationMemberValue, JavaAnnotationArgument> NAMELESS_ANNOTATION_ARGUMENTS = new Factory<PsiAnnotationMemberValue, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiAnnotationMemberValue psiAnnotationMemberValue) {
                return JavaAnnotationArgumentImpl.create(psiAnnotationMemberValue, null);
            }
        };
        private static final Factory<PsiNameValuePair, JavaAnnotationArgument> NAMED_ANNOTATION_ARGUMENTS = new Factory<PsiNameValuePair, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiNameValuePair psiNameValuePair) {
                String name = psiNameValuePair.getName();
                PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                assert (value != null) : "Annotation argument value cannot be null: " + name;
                return JavaAnnotationArgumentImpl.create(value, name == null ? null : Name.identifier(name));
            }
        };

        private Factories() {
        }
    }

    private static interface Factory<Psi, Java> {
        @NotNull
        public Java create(@NotNull Psi var1);
    }
}

