/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class JetFilesProvider {
    public static JetFilesProvider getInstance(Project project) {
        return ServiceManager.getService(project, JetFilesProvider.class);
    }

    public final Function<JetFile, Collection<JetFile>> allNamespaceFiles() {
        return new Function<JetFile, Collection<JetFile>>(){

            @Override
            public Collection<JetFile> fun(JetFile file) {
                return Collections2.filter(JetFilesProvider.this.sampleToAllFilesInModule().fun(file), new SameJetFilePredicate(file));
            }
        };
    }

    public abstract Function<JetFile, Collection<JetFile>> sampleToAllFilesInModule();

    public abstract Collection<JetFile> allInScope(@NotNull GlobalSearchScope var1);

    public abstract boolean isFileInScope(@NotNull JetFile var1, @NotNull GlobalSearchScope var2);

    public static class SameJetFilePredicate
    implements Predicate<PsiFile> {
        private final FqName name;

        public SameJetFilePredicate(JetFile file) {
            this.name = JetPsiUtil.getFQName(file);
        }

        @Override
        public boolean apply(PsiFile psiFile) {
            return JetPsiUtil.getFQName((JetFile)psiFile).equals(this.name);
        }
    }
}

