/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionCodeFragment;
import org.jetbrains.jet.lang.psi.JetExpressionCodeFragmentImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUnparsingUtils;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeCodeFragment;
import org.jetbrains.jet.lang.psi.JetTypeCodeFragmentImpl;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetFileType;

public class JetPsiFactory {
    public static ASTNode createValNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = 1");
        return property.getValOrVarNode();
    }

    public static ASTNode createVarNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "var x = 1");
        return property.getValOrVarNode();
    }

    public static ASTNode createValOrVarNode(Project project, String text) {
        return JetPsiFactory.createParameterList(project, "(" + text + " int x)").getParameters().get(0).getValOrVarNode();
    }

    public static JetExpression createExpression(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = " + text);
        return property.getInitializer();
    }

    public static JetValueArgumentList createCallArguments(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = foo" + text);
        JetExpression initializer = property.getInitializer();
        JetCallExpression callExpression = (JetCallExpression)initializer;
        return callExpression.getValueArgumentList();
    }

    public static JetTypeArgumentList createTypeArguments(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = foo" + text + "()");
        JetExpression initializer = property.getInitializer();
        JetCallExpression callExpression = (JetCallExpression)initializer;
        return callExpression.getTypeArgumentList();
    }

    public static JetTypeReference createType(Project project, String type) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : " + type);
        return property.getTypeRef();
    }

    @NotNull
    public static PsiElement createStar(Project project) {
        PsiElement star = JetPsiFactory.createType(project, "List<*>").findElementAt(5);
        assert (star != null);
        return star;
    }

    @NotNull
    public static PsiElement createComma(Project project) {
        PsiElement comma = JetPsiFactory.createType(project, "T<X, Y>").findElementAt(3);
        assert (comma != null);
        return comma;
    }

    public static Pair<PsiElement, PsiElement> createColonAndWhiteSpaces(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : Int");
        return Pair.create(property.findElementAt(5), property.findElementAt(7));
    }

    public static Pair<PsiElement, PsiElement> createTypeWhiteSpaceAndColon(Project project, String type) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: " + type);
        return Pair.create(property.findElementAt(5), property.getTypeRef());
    }

    public static ASTNode createColonNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: Int");
        return property.getNode().findChildByType(JetTokens.COLON);
    }

    @NotNull
    public static PsiElement createSemicolon(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: Int;");
        PsiElement semicolon = property.findElementAt(10);
        assert (semicolon != null);
        return semicolon;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createWhitespaceAndArrow(Project project) {
        JetFunctionType functionType = (JetFunctionType)JetPsiFactory.createType(project, "() -> Int").getTypeElement();
        assert (functionType != null);
        return Pair.create(functionType.findElementAt(2), functionType.findElementAt(3));
    }

    public static PsiElement createWhiteSpace(Project project) {
        return JetPsiFactory.createWhiteSpace(project, " ");
    }

    private static PsiElement createWhiteSpace(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val" + text + "x");
        return property.findElementAt(3);
    }

    public static PsiElement createNewLine(Project project) {
        return JetPsiFactory.createWhiteSpace(project, "\n");
    }

    public static JetClass createClass(Project project, String text) {
        return JetPsiFactory.createDeclaration(project, text, JetClass.class);
    }

    @NotNull
    public static JetFile createFile(Project project, String text) {
        return JetPsiFactory.createFile(project, "dummy.jet", text);
    }

    @NotNull
    public static JetFile createFile(Project project, String fileName, String text) {
        return (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false);
    }

    @NotNull
    public static JetFile createPhysicalFile(Project project, String fileName, String text) {
        return (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), true);
    }

    public static JetProperty createProperty(Project project, String name, String type, boolean isVar, @Nullable String initializer) {
        String text = (isVar ? "var " : "val ") + name + (type != null ? ":" + type : "") + (initializer == null ? "" : " = " + initializer);
        return JetPsiFactory.createProperty(project, text);
    }

    public static JetProperty createProperty(Project project, String name, String type, boolean isVar) {
        return JetPsiFactory.createProperty(project, name, type, isVar, null);
    }

    public static JetProperty createProperty(Project project, String text) {
        return JetPsiFactory.createDeclaration(project, text, JetProperty.class);
    }

    public static <T> T createDeclaration(Project project, String text, Class<T> clazz) {
        JetFile file = JetPsiFactory.createFile(project, text);
        List<JetDeclaration> dcls = file.getDeclarations();
        assert (dcls.size() == 1) : dcls.size() + " declarations in " + text;
        JetDeclaration result = dcls.get(0);
        return (T)result;
    }

    public static PsiElement createNameIdentifier(Project project, String name) {
        return JetPsiFactory.createProperty(project, name, null, false).getNameIdentifier();
    }

    public static JetSimpleNameExpression createSimpleName(Project project, String name) {
        return (JetSimpleNameExpression)JetPsiFactory.createProperty(project, name, null, false, name).getInitializer();
    }

    public static PsiElement createIdentifier(Project project, String name) {
        return JetPsiFactory.createSimpleName(project, name).getIdentifier();
    }

    public static JetNamedFunction createFunction(Project project, String funDecl) {
        return JetPsiFactory.createDeclaration(project, funDecl, JetNamedFunction.class);
    }

    public static JetModifierList createModifierList(Project project, JetKeywordToken modifier) {
        String text = modifier.getValue() + " val x";
        JetProperty property = JetPsiFactory.createProperty(project, text);
        return property.getModifierList();
    }

    public static JetModifierList createConstructorModifierList(Project project, JetKeywordToken modifier) {
        JetClass aClass = JetPsiFactory.createClass(project, "class C " + modifier.getValue() + " (){}");
        return aClass.getPrimaryConstructorModifierList();
    }

    public static JetExpression createEmptyBody(Project project) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo() {}");
        return function.getBodyExpression();
    }

    public static JetClassBody createEmptyClassBody(Project project) {
        JetClass aClass = JetPsiFactory.createClass(project, "class A(){}");
        return aClass.getBody();
    }

    public static JetParameter createParameter(Project project, String name, String type) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo(" + name + " : " + type + ") {}");
        return function.getValueParameters().get(0);
    }

    public static JetParameterList createParameterList(Project project, String text) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo" + text + "{}");
        return function.getValueParameterList();
    }

    @NotNull
    public static JetWhenEntry createWhenEntry(@NotNull Project project, @NotNull String entryText) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo() { when(12) { " + entryText + " } }");
        JetWhenEntry whenEntry = PsiTreeUtil.findChildOfType(function, JetWhenEntry.class);
        assert (whenEntry != null) : "Couldn't generate when entry";
        assert (entryText.equals(whenEntry.getText())) : "Generate when entry text differs from the given text";
        return whenEntry;
    }

    public static JetStringTemplateEntryWithExpression createBlockStringTemplateEntry(@NotNull Project project, @NotNull JetExpression expression) {
        JetStringTemplateExpression stringTemplateExpression = (JetStringTemplateExpression)JetPsiFactory.createExpression(project, "\"${" + expression.getText() + "}\"");
        return (JetStringTemplateEntryWithExpression)stringTemplateExpression.getEntries()[0];
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull String path) {
        return JetPsiFactory.createImportDirective(project, new ImportPath(path));
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull ImportPath importPath) {
        if (importPath.fqnPart().isRoot()) {
            throw new IllegalArgumentException("import path must not be empty");
        }
        StringBuilder importDirectiveBuilder = new StringBuilder("import ");
        importDirectiveBuilder.append(importPath.getPathStr());
        Name alias = importPath.getAlias();
        if (alias != null) {
            importDirectiveBuilder.append(" as ").append(alias.asString());
        }
        JetFile namespace = JetPsiFactory.createFile(project, importDirectiveBuilder.toString());
        return namespace.getImportDirectives().iterator().next();
    }

    public static PsiElement createPrimaryConstructor(Project project) {
        JetClass aClass = JetPsiFactory.createClass(project, "class A()");
        return aClass.findElementAt(7).getParent();
    }

    public static JetSimpleNameExpression createClassLabel(Project project, @NotNull String labelName) {
        JetThisExpression expression = (JetThisExpression)JetPsiFactory.createExpression(project, "this@" + labelName);
        return expression.getTargetLabel();
    }

    public static JetExpression createFieldIdentifier(Project project, @NotNull String fieldName) {
        return JetPsiFactory.createExpression(project, "$" + fieldName);
    }

    @NotNull
    public static JetBinaryExpression createBinaryExpression(Project project, @NotNull String lhs, @NotNull String op, @NotNull String rhs) {
        return (JetBinaryExpression)JetPsiFactory.createExpression(project, lhs + " " + op + " " + rhs);
    }

    @NotNull
    public static JetBinaryExpression createBinaryExpression(Project project, @Nullable JetExpression lhs, @NotNull String op, @Nullable JetExpression rhs) {
        return JetPsiFactory.createBinaryExpression(project, JetPsiUtil.getText(lhs), op, JetPsiUtil.getText(rhs));
    }

    public static JetTypeCodeFragment createTypeCodeFragment(Project project, String text, PsiElement context) {
        return new JetTypeCodeFragmentImpl(project, "fragment.kt", text, context);
    }

    public static JetExpressionCodeFragment createExpressionCodeFragment(Project project, String text, PsiElement context) {
        return new JetExpressionCodeFragmentImpl(project, "fragment.kt", text, context);
    }

    @NotNull
    public static JetReturnExpression createReturn(Project project, @NotNull String text) {
        return (JetReturnExpression)JetPsiFactory.createExpression(project, "return " + text);
    }

    @NotNull
    public static JetReturnExpression createReturn(Project project, @Nullable JetExpression expression) {
        return JetPsiFactory.createReturn(project, JetPsiUtil.getText(expression));
    }

    @NotNull
    public static JetIfExpression createIf(Project project, @Nullable JetExpression condition, @Nullable JetExpression thenExpr, @Nullable JetExpression elseExpr) {
        return (JetIfExpression)JetPsiFactory.createExpression(project, JetPsiUnparsingUtils.toIf(condition, thenExpr, elseExpr));
    }

    @NotNull
    public static JetValueArgument createArgumentWithName(@NotNull Project project, @NotNull String name, @NotNull JetExpression argumentExpression) {
        return JetPsiFactory.createCallArguments(project, "(" + name + " = " + argumentExpression.getText() + ")").getArguments().get(0);
    }

    public static JetExpression createFunctionBody(Project project, @NotNull String bodyText) {
        JetNamedFunction func = JetPsiFactory.createFunction(project, "fun foo() {\n" + bodyText + "\n}");
        return func.getBodyExpression();
    }

    public static JetClassObject createEmptyClassObject(Project project) {
        JetClass klass = JetPsiFactory.createClass(project, "class foo { class object { } }");
        return klass.getClassObject();
    }

    public static JetBlockExpression wrapInABlock(final @NotNull JetExpression expression) {
        if (expression instanceof JetBlockExpression) {
            return (JetBlockExpression)expression;
        }
        JetNamedFunction function = JetPsiFactory.createFunction(expression.getProject(), "fun f() { " + expression.getText() + "}");
        JetBlockExpression block = (JetBlockExpression)function.getBodyExpression();
        assert (block != null);
        return new JetBlockExpression(block.getNode()){

            @Override
            @NotNull
            public List<JetElement> getStatements() {
                return Collections.singletonList(expression);
            }
        };
    }

    public static class WhenBuilder {
        private final StringBuilder sb = new StringBuilder("when ");
        private boolean frozen = false;
        private boolean inCondition = false;

        public WhenBuilder() {
            this((String)null);
        }

        public WhenBuilder(@Nullable String subjectText) {
            if (subjectText != null) {
                this.sb.append("(").append(subjectText).append(") ");
            }
            this.sb.append("{\n");
        }

        public WhenBuilder(@Nullable JetExpression subject) {
            this(subject != null ? subject.getText() : null);
        }

        @NotNull
        public WhenBuilder condition(@NotNull String text) {
            assert (!this.frozen);
            if (!this.inCondition) {
                this.inCondition = true;
            } else {
                this.sb.append(", ");
            }
            this.sb.append(text);
            return this;
        }

        @NotNull
        public WhenBuilder condition(@Nullable JetExpression expression) {
            return this.condition(JetPsiUtil.getText(expression));
        }

        @NotNull
        public WhenBuilder pattern(@NotNull String typeReferenceText, boolean negated) {
            return this.condition((negated ? "!is" : "is") + " " + typeReferenceText);
        }

        @NotNull
        public WhenBuilder pattern(@Nullable JetTypeReference typeReference, boolean negated) {
            return this.pattern(JetPsiUtil.getText(typeReference), negated);
        }

        @NotNull
        public WhenBuilder range(@NotNull String argumentText, boolean negated) {
            return this.condition((negated ? "!in" : "in") + " " + argumentText);
        }

        @NotNull
        public WhenBuilder range(@Nullable JetExpression argument, boolean negated) {
            return this.range(JetPsiUtil.getText(argument), negated);
        }

        @NotNull
        public WhenBuilder branchExpression(@NotNull String expressionText) {
            assert (!this.frozen);
            assert (this.inCondition);
            this.inCondition = false;
            this.sb.append(" -> ").append(expressionText).append("\n");
            return this;
        }

        @NotNull
        public WhenBuilder branchExpression(@Nullable JetExpression expression) {
            return this.branchExpression(JetPsiUtil.getText(expression));
        }

        @NotNull
        public WhenBuilder entry(@NotNull String entryText) {
            assert (!this.frozen);
            assert (!this.inCondition);
            this.sb.append(entryText).append("\n");
            return this;
        }

        @NotNull
        public WhenBuilder entry(@Nullable JetWhenEntry whenEntry) {
            return this.entry(JetPsiUtil.getText(whenEntry));
        }

        @NotNull
        public WhenBuilder elseEntry(@NotNull String text) {
            return this.entry("else -> " + text);
        }

        @NotNull
        public WhenBuilder elseEntry(@Nullable JetExpression expression) {
            return this.elseEntry(JetPsiUtil.getText(expression));
        }

        @NotNull
        public JetWhenExpression toExpression(Project project) {
            if (!this.frozen) {
                this.sb.append("}");
                this.frozen = true;
            }
            return (JetWhenExpression)JetPsiFactory.createExpression(project, this.sb.toString());
        }
    }

    public static class IfChainBuilder {
        private final StringBuilder sb = new StringBuilder();
        private boolean first = true;
        private boolean frozen = false;

        @NotNull
        public IfChainBuilder ifBranch(@NotNull String conditionText, @NotNull String expressionText) {
            if (this.first) {
                this.first = false;
            } else {
                this.sb.append("else ");
            }
            this.sb.append("if (").append(conditionText).append(") ").append(expressionText).append("\n");
            return this;
        }

        @NotNull
        public IfChainBuilder ifBranch(@NotNull JetExpression condition, @NotNull JetExpression expression) {
            return this.ifBranch(condition.getText(), expression.getText());
        }

        @NotNull
        public IfChainBuilder elseBranch(@NotNull String expressionText) {
            this.sb.append("else ").append(expressionText);
            return this;
        }

        @NotNull
        public IfChainBuilder elseBranch(@Nullable JetExpression expression) {
            return this.elseBranch(JetPsiUtil.getText(expression));
        }

        @NotNull
        public JetIfExpression toExpression(Project project) {
            if (!this.frozen) {
                this.frozen = true;
            }
            return (JetIfExpression)JetPsiFactory.createExpression(project, this.sb.toString());
        }
    }
}

