/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.annotations;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;

public class AnnotationDescriptor {
    private JetType annotationType;
    private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments = Maps.newHashMap();

    @NotNull
    public JetType getType() {
        return this.annotationType;
    }

    @Nullable
    public CompileTimeConstant<?> getValueArgument(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
        return this.valueArguments.get(valueParameterDescriptor);
    }

    @NotNull
    public Map<ValueParameterDescriptor, CompileTimeConstant<?>> getAllValueArguments() {
        return Collections.unmodifiableMap(this.valueArguments);
    }

    public void setAnnotationType(@NotNull JetType annotationType) {
        this.annotationType = annotationType;
    }

    public void setValueArgument(@NotNull ValueParameterDescriptor name, @NotNull CompileTimeConstant<?> value) {
        this.valueArguments.put(name, value);
    }

    public String toString() {
        return this.annotationType.toString() + DescriptorUtils.getSortedValueArguments(this, null);
    }
}

