/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.utils.ExceptionUtils;

public class NameSerializationUtil {
    private NameSerializationUtil() {
    }

    @NotNull
    public static NameResolver deserializeNameResolver(@NotNull InputStream in) {
        try {
            ProtoBuf.SimpleNameTable simpleNames = ProtoBuf.SimpleNameTable.parseDelimitedFrom(in);
            ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
            return new NameResolver(simpleNames, qualifiedNames);
        }
        catch (IOException e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    public static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        NameSerializationUtil.serializeNameTable(out, nameResolver.getSimpleNameTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeNameTable(@NotNull OutputStream out, @NotNull NameTable nameTable) {
        NameSerializationUtil.serializeNameTable(out, NameSerializationUtil.toSimpleNameTable(nameTable), NameSerializationUtil.toQualifiedNameTable(nameTable));
    }

    private static void serializeNameTable(@NotNull OutputStream out, @NotNull ProtoBuf.SimpleNameTable simpleNameTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        try {
            simpleNameTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    @NotNull
    public static ProtoBuf.SimpleNameTable toSimpleNameTable(@NotNull NameTable nameTable) {
        ProtoBuf.SimpleNameTable.Builder simpleNames = ProtoBuf.SimpleNameTable.newBuilder();
        for (String simpleName : nameTable.getSimpleNames()) {
            simpleNames.addName(simpleName);
        }
        return simpleNames.build();
    }

    @NotNull
    public static ProtoBuf.QualifiedNameTable toQualifiedNameTable(@NotNull NameTable nameTable) {
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (ProtoBuf.QualifiedNameTable.QualifiedName.Builder qName : nameTable.getFqNames()) {
            qualifiedNames.addQualifiedName(qName);
        }
        return qualifiedNames.build();
    }

    @NotNull
    public static NameResolver createNameResolver(@NotNull NameTable table) {
        return new NameResolver(NameSerializationUtil.toSimpleNameTable(table), NameSerializationUtil.toQualifiedNameTable(table));
    }
}

