/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.codegen.state.JetTypeMapperMode;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class ClassFileFactory
extends GenerationStateAware {
    @NotNull
    private ClassBuilderFactory builderFactory;
    private final Map<FqName, NamespaceCodegen> ns2codegen = new HashMap<FqName, NamespaceCodegen>();
    private final Map<String, ClassBuilder> generators = new LinkedHashMap<String, ClassBuilder>();
    private boolean isDone = false;

    public ClassFileFactory(@NotNull GenerationState state) {
        super(state);
    }

    public void setBuilderFactory(@NotNull ClassBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    @NotNull
    ClassBuilder newVisitor(@NotNull JvmClassName className, @NotNull PsiFile sourceFile) {
        return this.newVisitor(className, Collections.singletonList(sourceFile));
    }

    @NotNull
    private ClassBuilder newVisitor(@NotNull JvmClassName className, @NotNull Collection<? extends PsiFile> sourceFiles) {
        String outputFilePath = className.getInternalName() + ".class";
        this.state.getProgress().reportOutput(ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles), new File(outputFilePath));
        ClassBuilder answer = this.builderFactory.newClassBuilder();
        this.generators.put(outputFilePath, answer);
        return answer;
    }

    private void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (NamespaceCodegen codegen : this.ns2codegen.values()) {
                codegen.done();
            }
        }
    }

    public String asText(String file) {
        this.done();
        return this.builderFactory.asText(this.generators.get(file));
    }

    public byte[] asBytes(String file) {
        this.done();
        return this.builderFactory.asBytes(this.generators.get(file));
    }

    public List<String> files() {
        this.done();
        return new ArrayList<String>(this.generators.keySet());
    }

    public String createText() {
        StringBuilder answer = new StringBuilder();
        List<String> files = this.files();
        for (String file : files) {
            answer.append("@").append(file).append('\n');
            answer.append(this.asText(file));
        }
        return answer.toString();
    }

    public NamespaceCodegen forNamespace(final FqName fqName, final Collection<JetFile> files) {
        assert (!this.isDone) : "Already done!";
        NamespaceCodegen codegen = this.ns2codegen.get(fqName);
        if (codegen == null) {
            ClassBuilderOnDemand onDemand = new ClassBuilderOnDemand(){

                @Override
                @NotNull
                protected ClassBuilder createClassBuilder() {
                    return ClassFileFactory.this.newVisitor(NamespaceCodegen.getJVMClassNameForKotlinNs(fqName), files);
                }
            };
            codegen = new NamespaceCodegen(onDemand, fqName, this.state, files);
            this.ns2codegen.put(fqName, codegen);
        }
        return codegen;
    }

    public ClassBuilder forClassImplementation(ClassDescriptor aClass, PsiFile sourceFile) {
        Type type = this.state.getTypeMapper().mapType(aClass.getDefaultType(), JetTypeMapperMode.IMPL);
        if (AsmUtil.isPrimitive(type)) {
            throw new IllegalStateException("Codegen for primitive type is not possible: " + aClass);
        }
        return this.newVisitor(JvmClassName.byType(type), sourceFile);
    }

    @NotNull
    public ClassBuilder forNamespacePart(@NotNull JvmClassName name, @NotNull PsiFile sourceFile) {
        return this.newVisitor(name, sourceFile);
    }

    @NotNull
    public ClassBuilder forTraitImplementation(@NotNull ClassDescriptor aClass, @NotNull GenerationState state, @NotNull PsiFile file) {
        Type type = state.getTypeMapper().mapType(aClass.getDefaultType(), JetTypeMapperMode.TRAIT_IMPL);
        return this.newVisitor(JvmClassName.byType(type), file);
    }

    private static Collection<File> toIoFilesIgnoringNonPhysical(Collection<? extends PsiFile> psiFiles) {
        ArrayList<File> result = Lists.newArrayList();
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            result.add(new File(virtualFile.getPath()));
        }
        return result;
    }
}

