/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    @Override
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftHashMap", "createKey"));
        }
        return new SoftKey(k, q);
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private SoftKey(T k, ReferenceQueue<? super T> q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

