/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this(list, list.getExpressionTypes(), languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, @NotNull PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        if (argumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (actualParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "resolveConflict"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        int applicabilityLevel = JavaMethodsConflictResolver.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkLambdaApplicable(conflicts, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSpecifics(conflicts, applicabilityLevel, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.myActualParameterTypes.length);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet<CandidateInfo> uniques = new THashSet<CandidateInfo>(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private void checkLambdaApplicable(@NotNull List<CandidateInfo> conflicts, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkLambdaApplicable"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkLambdaApplicable"));
        }
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return;
        }
        for (int i = 0; i < this.myActualParameterTypes.length; ++i) {
            PsiType parameterType = this.myActualParameterTypes[i];
            if (!(parameterType instanceof PsiLambdaExpressionType)) continue;
            PsiLambdaExpression lambdaExpression = ((PsiLambdaExpressionType)parameterType).getExpression();
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                PsiParameter[] methodParameters;
                ProgressManager.checkCanceled();
                CandidateInfo conflict = iterator.next();
                PsiMethod method = (PsiMethod)conflict.getElement();
                if (method == null || (methodParameters = method.getParameterList().getParameters()).length == 0) continue;
                PsiParameter param = i < methodParameters.length ? methodParameters[i] : methodParameters[methodParameters.length - 1];
                PsiType paramType = param.getType();
                if (LambdaUtil.isAcceptable(lambdaExpression, conflict.getSubstitutor().substitute(paramType), true)) continue;
                iterator.remove();
            }
        }
        LambdaUtil.checkMoreSpecificReturnType(conflicts, this.myActualParameterTypes);
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.checkSameConflicts(method, conflict)) continue;
                    switch (this.isMoreSpecific(method, conflict, applicabilityLevel, languageLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean checkSameConflicts(CandidateInfo method, CandidateInfo conflict) {
        assert (method != conflict);
        return false;
    }

    private static void checkAccessStaticLevels(List<CandidateInfo> conflicts, boolean checkAccessible) {
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    private void checkSameSignatures(@NotNull List<CandidateInfo> conflicts) {
        PsiMethod method;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        THashMap<MethodSignature, CandidateInfo> signatures = new THashMap<MethodSignature, CandidateInfo>(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        for (CandidateInfo conflict : conflicts) {
            method = ((MethodCandidateInfo)conflict).getElement();
            for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if ("java.lang.Object".equals(superMethod.getContainingClass().getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        block2: for (int i = 0; i < conflicts.size(); ++i) {
            PsiReferenceExpression expression;
            PsiExpression qualifierExpression;
            PsiClass currentClass;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            method = (PsiMethod)info.getElement();
            assert (method != null);
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = info.getSubstitutor();
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            assert (existingMethod != null);
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                signatures.put(signature, info);
                continue;
            }
            if (method == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor(scope1, scope2, true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method, existingMethod)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) {
                signatures.put(signature, info);
                int index = conflicts.indexOf(existing);
                conflicts.remove(index);
                --i;
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf(class1, existingClass, true) || InheritanceUtil.isInheritorOrSelf(existingClass, class1, true)) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
                int parametersLength = parameters.length;
                for (int i1 = 0; i1 < parametersLength; ++i1) {
                    if (!(parameters[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                    signatures.put(signature, info);
                    continue block2;
                }
                PsiType returnType1 = method.getReturnType();
                PsiType returnType2 = existingMethod.getReturnType();
                if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = existing.getSubstitutor().substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                    conflicts.remove(i);
                    --i;
                    continue;
                }
                signatures.put(signature, info);
                continue;
            }
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(this.myArgumentsList, PsiMethodCallExpression.class);
            if (methodCallExpression == null || (currentClass = (qualifierExpression = (expression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null ? PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType()) : PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null || !InheritanceUtil.isInheritorOrSelf(currentClass, class1, true) || !InheritanceUtil.isInheritorOrSelf(currentClass, existingClass, true)) continue;
            PsiSubstitutor eSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(existingClass, currentClass, PsiSubstitutor.EMPTY);
            PsiSubstitutor cSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(class1, currentClass, PsiSubstitutor.EMPTY);
            if (!MethodSignatureUtil.areSignaturesEqual(existingMethod.getSignature(eSubstitutor), method.getSignature(cSubstitutor))) continue;
            PsiType returnType = eSubstitutor.substitute(existingMethod.getReturnType());
            PsiType returnType1 = cSubstitutor.substitute(method.getReturnType());
            if (returnType == null || returnType1 == null || returnType1.equals(returnType)) continue;
            if (TypeConversionUtil.isAssignable(returnType, returnType1, false)) {
                if (class1.isInterface() && !existingClass.isInterface()) continue;
                conflicts.remove(existing);
            } else {
                if (!TypeConversionUtil.isAssignable(returnType1, returnType, false)) continue;
                conflicts.remove(i);
            }
            --i;
            break;
        }
    }

    private static boolean areTypeParametersAgree(CandidateInfo info) {
        return ((MethodCandidateInfo)info).isApplicable();
    }

    private static boolean checkParametersNumber(List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            if (method.isVarArgs()) {
                return true;
            }
            if (method.getParameterList().getParametersCount() == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index = unmatchedIndices.get(u);
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    private static int checkApplicability(List<CandidateInfo> conflicts) {
        int level;
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = JavaMethodsConflictResolver.preferVarargs((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = JavaMethodsConflictResolver.preferVarargs(info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    private static int preferVarargs(CandidateInfo info) {
        PsiMethod psiMethod;
        int level = ((MethodCandidateInfo)info).getApplicabilityLevel();
        if (level == 3 && (psiMethod = (PsiMethod)info.getElement()) != null && psiMethod.isVarArgs() && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7)) {
            return level + 1;
        }
        return level;
    }

    private static int getCheckAccessLevel(MethodCandidateInfo method) {
        boolean visible = method.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(MethodCandidateInfo method) {
        boolean available = method.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private static boolean isBoxingHappened(PsiType argType, PsiType parameterType, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isBoxingHappened"));
        }
        if (argType == null) {
            return parameterType instanceof PsiPrimitiveType;
        }
        if (parameterType instanceof PsiClassType) {
            parameterType = ((PsiClassType)parameterType).setLanguageLevel(languageLevel);
        }
        return TypeConversionUtil.boxingConversionApplicable(parameterType, argType);
    }

    private Specifics isMoreSpecific(CandidateInfo info1, CandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        boolean raw2;
        boolean raw1;
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        PsiMethod method1 = (PsiMethod)info1.getElement();
        PsiMethod method2 = (PsiMethod)info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = info1.getSubstitutor();
        PsiSubstitutor classSubstitutor2 = info2.getSubstitutor();
        int max = Math.max(params1.length, params2.length);
        PsiType[] types1 = new PsiType[max];
        PsiType[] types2 = new PsiType[max];
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && (!JavaVersionService.getInstance().isAtLeast(class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        int[] boxingHappened = new int[2];
        for (int i = 0; i < types1.length; ++i) {
            ProgressManager.checkCanceled();
            PsiType type1 = classSubstitutor1.substitute(types1[i]);
            PsiType type2 = classSubstitutor2.substitute(types2[i]);
            PsiType argType = i < this.myActualParameterTypes.length ? this.myActualParameterTypes[i] : null;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType, type1, languageLevel)) {
                boxingHappened[0] = boxingHappened[0] + 1;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType, type2, languageLevel)) {
                boxingHappened[1] = boxingHappened[1] + 1;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (boxingHappened[0] == 0 && boxingHappened[1] > 0) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] > 0 && boxingHappened[1] == 0) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = ((MethodCandidateInfo)info1).getSiteSubstitutor();
            PsiSubstitutor siteSubstitutor2 = ((MethodCandidateInfo)info2).getSiteSubstitutor();
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, typeParameters1, languageLevel, methodSubstitutor1, varargsPosition);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, typeParameters2, languageLevel, methodSubstitutor2, varargsPosition);
            if (applicable12 || applicable21) {
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract");
                boolean abstract2 = method2.hasModifierProperty("abstract");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable(lastParamType2, lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable(lastParamType1, lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature(method1.getSignature(info1.getSubstitutor()), method2.getSignature(info2.getSubstitutor()))) {
                    return Specifics.SECOND;
                }
                if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    return Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) || class2.isInterface()) {
                if (MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY)) && MethodSignatureUtil.isSubsignature(method2.getSignature(info2.getSubstitutor()), method1.getSignature(info1.getSubstitutor()))) {
                    return Specifics.FIRST;
                }
                if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    return Specifics.FIRST;
                }
            }
        }
        if ((raw1 = PsiUtil.isRawSubstitutor(method1, classSubstitutor1)) ^ (raw2 = PsiUtil.isRawSubstitutor(method2, classSubstitutor2))) {
            return raw1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private boolean isApplicableTo(PsiType[] argTypes, PsiMethod method, PsiTypeParameter[] typeParameters, LanguageLevel languageLevel, PsiSubstitutor methodSubstitutor, boolean checkVarargs) {
        boolean applicable;
        int applicabilityLevel = PsiUtil.getApplicabilityLevel(method, methodSubstitutor, argTypes, languageLevel, false, checkVarargs);
        boolean bl = applicable = applicabilityLevel > 1;
        if (applicable && !GenericsUtil.isTypeArgumentsApplicable(typeParameters, methodSubstitutor, this.myArgumentsList, false)) {
            return false;
        }
        return applicable;
    }

    private static PsiType[] typesAtSite(PsiType[] types1, PsiSubstitutor siteSubstitutor1) {
        PsiType[] types = new PsiType[types1.length];
        for (int i = 0; i < types1.length; ++i) {
            types[i] = siteSubstitutor1.substitute(types1[i]);
        }
        return types;
    }

    private static PsiSubstitutor calculateMethodSubstitutor(PsiTypeParameter[] typeParameters, PsiMethod method, PsiSubstitutor siteSubstitutor, PsiType[] types1, PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance(method.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(method)) {
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (substitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, siteSubstitutor.substitute(typeParameter));
        }
        return substitutor;
    }

    public void checkPrimitiveVarargs(List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method;
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || method == null || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

