/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class InferenceGraphNode<T> {
    private final T myValue;
    private final List<InferenceGraphNode<T>> myDependencies = new ArrayList<InferenceGraphNode<T>>();
    private int index = -1;
    private int lowlink;

    public InferenceGraphNode(T value) {
        this.myValue = value;
    }

    public T getValue() {
        return this.myValue;
    }

    public List<InferenceGraphNode<T>> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(InferenceGraphNode<T> node) {
        this.myDependencies.add(node);
    }

    public static <T> List<List<InferenceGraphNode<T>>> tarjan(Collection<InferenceGraphNode<T>> nodes) {
        ArrayList<List<InferenceGraphNode<T>>> result = new ArrayList<List<InferenceGraphNode<T>>>();
        Stack<InferenceGraphNode<T>> currentStack = new Stack<InferenceGraphNode<T>>();
        int index = 0;
        for (InferenceGraphNode<T> node : nodes) {
            if (node.index != -1) continue;
            index += InferenceGraphNode.strongConnect(node, index, currentStack, result);
        }
        return result;
    }

    private static <T> int strongConnect(InferenceGraphNode<T> currentNode, int index, Stack<InferenceGraphNode<T>> currentStack, ArrayList<List<InferenceGraphNode<T>>> result) {
        currentNode.index = index;
        currentNode.lowlink = index++;
        currentStack.push(currentNode);
        for (InferenceGraphNode<T> dependantNode : currentNode.getDependencies()) {
            if (dependantNode.index == -1) {
                InferenceGraphNode.strongConnect(dependantNode, index, currentStack, result);
                currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.lowlink);
                continue;
            }
            if (!currentStack.contains(dependantNode)) continue;
            currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.index);
        }
        if (currentNode.lowlink == currentNode.index) {
            InferenceGraphNode<T> cyclicNode;
            ArrayList<InferenceGraphNode<T>> arrayList = new ArrayList<InferenceGraphNode<T>>();
            do {
                cyclicNode = currentStack.pop();
                arrayList.add(cyclicNode);
            } while (cyclicNode != currentNode);
            result.add(arrayList);
        }
        return index;
    }
}

