/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.translate.test.JSTester;
import org.jetbrains.k2js.translate.test.QUnitTester;

public abstract class Config {
    @NotNull
    public static final String REWRITABLE_MODULE_NAME = "JS_TESTS";
    @NotNull
    public static final List<String> LIB_FILES_WITH_DECLARATIONS = Arrays.asList("/core/annotations.kt", "/core/core.kt", "/core/date.kt", "/core/dom.kt", "/core/javaio.kt", "/core/javalang.kt", "/core/javautil.kt", "/core/javautilCollections.kt", "/core/json.kt", "/core/kotlin.kt", "/core/math.kt", "/core/string.kt", "/dom/domcore.kt", "/dom/html/htmlcore.kt", "/dom/html5/canvas.kt", "/dom/html/window.kt", "/jquery/common.kt", "/jquery/ui.kt", "/junit/core.kt", "/qunit/core.kt", "/stdlib/browser.kt");
    @NotNull
    public static final List<String> LIB_FILES_WITH_CODE = Arrays.asList("/stdlib/TuplesCode.kt", "/core/javautilCollectionsCode.kt");
    @NotNull
    public static final List<String> LIB_FILE_NAMES = Lists.newArrayList();
    @NotNull
    public static final List<String> LIB_FILE_NAMES_DEPENDENT_ON_STDLIB;
    public static final String LIBRARIES_LOCATION = "js/js.libraries/src";
    @NotNull
    public static final List<String> STDLIB_FILE_NAMES;
    public static final String STDLIB_LOCATION = "libraries/stdlib/src";
    @NotNull
    private final Project project;
    @Nullable
    private List<JetFile> libFiles = null;
    @NotNull
    private final EcmaVersion target;
    @NotNull
    private final String moduleId;

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project, @NotNull EcmaVersion ecmaVersion) {
        return new Config(project, "main", ecmaVersion){

            @Override
            @NotNull
            protected List<JetFile> generateLibFiles() {
                return Collections.emptyList();
            }
        };
    }

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project) {
        return Config.getEmptyConfig(project, EcmaVersion.defaultVersion());
    }

    public Config(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion) {
        this.project = project;
        this.target = ecmaVersion;
        this.moduleId = moduleId;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public EcmaVersion getTarget() {
        return this.target;
    }

    @NotNull
    public String getModuleId() {
        return this.moduleId;
    }

    @NotNull
    protected abstract List<JetFile> generateLibFiles();

    @NotNull
    public final List<JetFile> getLibFiles() {
        if (this.libFiles == null) {
            this.libFiles = this.generateLibFiles();
        }
        return this.libFiles;
    }

    @Nullable
    public BindingContext getLibraryBindingContext() {
        return null;
    }

    @NotNull
    public static Collection<JetFile> withJsLibAdded(@NotNull Collection<JetFile> files, @NotNull Config config) {
        ArrayList<JetFile> allFiles = Lists.newArrayList();
        allFiles.addAll(files);
        allFiles.addAll(config.getLibFiles());
        return allFiles;
    }

    @Nullable
    public JSTester getTester() {
        return new QUnitTester();
    }

    static {
        LIB_FILE_NAMES.addAll(LIB_FILES_WITH_DECLARATIONS);
        LIB_FILE_NAMES.addAll(LIB_FILES_WITH_CODE);
        LIB_FILE_NAMES_DEPENDENT_ON_STDLIB = Arrays.asList("/core/stringsCode.kt", "/stdlib/domCode.kt", "/stdlib/jutilCode.kt", "/stdlib/JUMapsCode.kt", "/stdlib/testCode.kt");
        STDLIB_FILE_NAMES = Arrays.asList("/kotlin/Preconditions.kt", "/kotlin/Iterators.kt", "/kotlin/JUtil.kt", "/kotlin/Arrays.kt", "/kotlin/Lists.kt", "/kotlin/Maps.kt", "/kotlin/Exceptions.kt", "/kotlin/IterablesSpecial.kt", "/generated/_Arrays.kt", "/generated/_Collections.kt", "/generated/_Iterables.kt", "/generated/_Iterators.kt", "/generated/_IteratorsCommon.kt", "/kotlin/support/AbstractIterator.kt", "/kotlin/Standard.kt", "/kotlin/Strings.kt", "/kotlin/dom/Dom.kt", "/kotlin/test/Test.kt");
    }
}

