/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.data;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class JetClassOrObjectInfo<E extends JetClassOrObject>
implements JetClassLikeInfo {
    protected final E element;

    protected JetClassOrObjectInfo(@NotNull E element) {
        this.element = element;
    }

    @Override
    public JetClassOrObject getCorrespondingClassOrObject() {
        return this.element;
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        return this.element.getDelegationSpecifiers();
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return this.element.getModifierList();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        return this.element.getDeclarations();
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        return this.element;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file = this.element.getContainingFile();
        if (file instanceof JetFile) {
            JetFile jetFile = (JetFile)file;
            JetNamespaceHeader header = jetFile.getNamespaceHeader();
            return header != null ? header.getFqName() : FqName.ROOT;
        }
        throw new IllegalArgumentException("Not in a JetFile: " + this.element);
    }

    public String toString() {
        return "info for " + this.element.getText();
    }
}

