/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaClassStaticMembersScope
extends JavaClassMembersScope {
    @NotNull
    private final FqName packageFQN;

    public JavaClassStaticMembersScope(@NotNull NamespaceDescriptor descriptor, @NotNull ClassPsiDeclarationProvider declarationProvider, @NotNull FqName packageFQN, @NotNull JavaSemanticServices semanticServices) {
        super((ClassOrNamespaceDescriptor)descriptor, declarationProvider, semanticServices);
        this.packageFQN = packageFQN;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.getResolver().resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        for (PsiClass nested : this.declarationProvider.getPsiClass().getInnerClasses()) {
            ContainerUtil.addIfNotNull(result, this.getNamespace(Name.identifier(nested.getName())));
        }
        return result;
    }
}

