/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.MembersCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassObjectResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameBase;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public final class JavaClassResolver {
    @NotNull
    private final Map<FqNameBase, ClassDescriptor> classDescriptorCache = new THashMap<FqNameBase, ClassDescriptor>(new TObjectHashingStrategy<FqNameBase>(){

        @Override
        public int computeHashCode(FqNameBase o) {
            if (o instanceof FqName) {
                return ((FqName)o).toUnsafe().hashCode();
            }
            assert (o instanceof FqNameUnsafe);
            return o.hashCode();
        }

        @Override
        public boolean equals(FqNameBase n1, FqNameBase n2) {
            return n1.equalsTo(n2.toString()) && n2.equalsTo(n1.toString());
        }
    });
    @NotNull
    private final Set<FqNameBase> unresolvedCache = Sets.newHashSet();
    private BindingTrace trace;
    private JavaSignatureResolver signatureResolver;
    private JavaSemanticServices semanticServices;
    private JavaAnnotationResolver annotationResolver;
    private PsiClassFinder psiClassFinder;
    private JavaNamespaceResolver namespaceResolver;
    private JavaClassObjectResolver classObjectResolver;
    private JavaSupertypeResolver supertypesResolver;
    private JavaFunctionResolver functionResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setSignatureResolver(JavaSignatureResolver signatureResolver) {
        this.signatureResolver = signatureResolver;
    }

    public void setClassObjectResolver(JavaClassObjectResolver classObjectResolver) {
        this.classObjectResolver = classObjectResolver;
    }

    public void setSemanticServices(JavaSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    public void setNamespaceResolver(JavaNamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setSupertypesResolver(JavaSupertypeResolver supertypesResolver) {
        this.supertypesResolver = supertypesResolver;
    }

    public void setFunctionResolver(JavaFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        PostponedTasks postponedTasks = new PostponedTasks();
        ClassDescriptor classDescriptor = this.resolveClass(qualifiedName, searchRule, postponedTasks);
        postponedTasks.performTasks();
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule, @NotNull PostponedTasks tasks) {
        if (JavaClassResolver.isTraitImplementation(qualifiedName)) {
            return null;
        }
        ClassDescriptor builtinClassDescriptor = this.semanticServices.getKotlinBuiltinClassDescriptor(qualifiedName);
        if (builtinClassDescriptor != null) {
            return builtinClassDescriptor;
        }
        ClassDescriptor kotlinClassDescriptor = this.semanticServices.getKotlinClassDescriptor(qualifiedName);
        if (kotlinClassDescriptor != null) {
            return searchRule.processFoundInKotlin(kotlinClassDescriptor);
        }
        FqNameUnsafe fqName = JavaClassResolver.javaClassToKotlinFqName(qualifiedName);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(fqName);
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        if (this.unresolvedCache.contains(fqName)) {
            return null;
        }
        return this.doResolveClass(qualifiedName, tasks);
    }

    private ClassDescriptor doResolveClass(@NotNull FqName qualifiedName, @NotNull PostponedTasks tasks) {
        PsiClass psiClass = this.psiClassFinder.findPsiClass(qualifiedName, PsiClassFinder.RuntimeClassesHandleMode.REPORT_ERROR);
        if (psiClass == null) {
            this.cacheNegativeValue(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            return null;
        }
        ClassDescriptor alreadyResolved = this.trace.get(BindingContext.CLASS, psiClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        return this.createJavaClassDescriptor(qualifiedName, psiClass, tasks);
    }

    private void cacheNegativeValue(@NotNull FqNameBase qualifiedName) {
        if (this.unresolvedCache.contains(qualifiedName) || this.classDescriptorCache.containsKey(qualifiedName)) {
            throw new IllegalStateException("rewrite at " + qualifiedName);
        }
        this.unresolvedCache.add(qualifiedName);
    }

    private static boolean isTraitImplementation(@NotNull FqName qualifiedName) {
        return qualifiedName.asString().endsWith("$$TImpl");
    }

    @NotNull
    private ClassDescriptor createJavaClassDescriptor(@NotNull FqName fqName, @NotNull PsiClass psiClass, @NotNull PostponedTasks taskList) {
        this.checkFqNamesAreConsistent(psiClass, fqName);
        DescriptorResolverUtils.checkPsiClassIsNotJet(psiClass);
        ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(psiClass);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(fqName));
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        assert (!this.unresolvedCache.contains(fqName)) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
        return this.doCreateClassDescriptor(fqName, psiClass, taskList, containingDeclaration);
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode doCreateClassDescriptor(@NotNull FqName fqName, @NotNull PsiClass psiClass, @NotNull PostponedTasks taskList, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        JetClassAnnotation jetClassAnnotation = JetClassAnnotation.get(psiClass);
        AbiVersionUtil.checkAbiVersion(psiClass, jetClassAnnotation, this.trace);
        ClassKind kind = JavaClassResolver.getClassKind(psiClass, jetClassAnnotation);
        ClassPsiDeclarationProvider classData = this.semanticServices.getPsiDeclarationProviderFactory().createBinaryClassData(psiClass);
        ClassDescriptorFromJvmBytecode classDescriptor = new ClassDescriptorFromJvmBytecode(containingDeclaration, kind, JavaClassResolver.isInnerClass(psiClass));
        this.cache(JavaClassResolver.javaClassToKotlinFqName(fqName), classDescriptor);
        classDescriptor.setName(Name.identifier(psiClass.getName()));
        List<JavaSignatureResolver.TypeParameterDescriptorInitialization> typeParameterDescriptorInitializations = this.signatureResolver.createUninitializedClassTypeParameters(psiClass, classDescriptor);
        classDescriptor.setTypeParameterDescriptors(JavaClassResolver.getTypeParametersDescriptors(typeParameterDescriptorInitializations));
        ArrayList<JetType> supertypes = Lists.newArrayList();
        classDescriptor.setSupertypes(supertypes);
        classDescriptor.setVisibility(DescriptorResolverUtils.resolveVisibility(psiClass, jetClassAnnotation));
        classDescriptor.setModality(JavaClassResolver.resolveModality(psiClass, classDescriptor));
        classDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope membersScope = new JavaClassNonStaticMembersScope(classDescriptor, classData, this.semanticServices);
        classDescriptor.setScopeForMemberLookup(membersScope);
        classDescriptor.setScopeForConstructorResolve(membersScope);
        String context = "class " + psiClass.getQualifiedName();
        this.signatureResolver.initializeTypeParameters(typeParameterDescriptorInitializations, classDescriptor, context);
        List<TypeParameterDescriptor> classTypeParameters = classDescriptor.getTypeConstructor().getParameters();
        supertypes.addAll(this.supertypesResolver.getSupertypes(classDescriptor, new PsiClassWrapper(psiClass), classData, classTypeParameters));
        ClassDescriptorFromJvmBytecode classObjectDescriptor = this.classObjectResolver.createClassObjectDescriptor(classDescriptor, psiClass);
        this.cache(DescriptorResolverUtils.getFqNameForClassObject(psiClass), classObjectDescriptor);
        if (classObjectDescriptor != null) {
            classDescriptor.getBuilder().setClassObjectDescriptor(classObjectDescriptor);
        }
        classDescriptor.setAnnotations(this.annotationResolver.resolveAnnotations(psiClass, taskList));
        this.trace.record(BindingContext.CLASS, psiClass, classDescriptor);
        PsiMethod samInterfaceMethod = MembersCache.getSamInterfaceMethod(psiClass);
        if (samInterfaceMethod != null) {
            SimpleFunctionDescriptor abstractMethod = this.resolveFunctionOfSamInterface(samInterfaceMethod, classDescriptor);
            classDescriptor.setFunctionTypeForSamInterface(SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod));
        }
        return classDescriptor;
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionOfSamInterface(@NotNull PsiMethod samInterfaceMethod, @NotNull ClassDescriptorFromJvmBytecode samInterface) {
        PsiClass methodContainer = samInterfaceMethod.getContainingClass();
        assert (methodContainer != null) : "method container is null for " + samInterfaceMethod;
        String containerQualifiedName = methodContainer.getQualifiedName();
        assert (containerQualifiedName != null) : "qualified name is null for " + methodContainer;
        if (DescriptorUtils.getFQName(samInterface).asString().equals(containerQualifiedName)) {
            SimpleFunctionDescriptor abstractMethod = this.functionResolver.resolveFunctionMutely(new PsiMethodWrapper(samInterfaceMethod), samInterface);
            assert (abstractMethod != null) : "couldn't resolve method " + samInterfaceMethod;
            return abstractMethod;
        }
        return JavaClassResolver.findFunctionWithMostSpecificReturnType(TypeUtils.getAllSupertypes(samInterface.getDefaultType()));
    }

    private static SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(@NotNull Set<JetType> supertypes) {
        ArrayList<SimpleFunctionDescriptor> candidates = Lists.newArrayList();
        for (JetType supertype : supertypes) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(supertype);
            if (abstractMembers.isEmpty()) continue;
            candidates.add((SimpleFunctionDescriptor)abstractMembers.get(0));
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes);
        }
        SimpleFunctionDescriptor currentMostSpecificType = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(candidate.getReturnType(), currentMostSpecificType.getReturnType())) continue;
            currentMostSpecificType = candidate;
        }
        return currentMostSpecificType;
    }

    private void cache(@NotNull FqNameBase fqName, @Nullable ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            this.cacheNegativeValue(fqName);
        } else {
            ClassDescriptor oldValue = this.classDescriptorCache.put(fqName, classDescriptor);
            assert (oldValue == null);
        }
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersDescriptors(@NotNull List<JavaSignatureResolver.TypeParameterDescriptorInitialization> typeParameterDescriptorInitializations) {
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        for (JavaSignatureResolver.TypeParameterDescriptorInitialization typeParameter : typeParameterDescriptorInitializations) {
            typeParameters.add(typeParameter.getDescriptor());
        }
        return typeParameters;
    }

    @NotNull
    private static Modality resolveModality(@NotNull PsiClass psiClass, @NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            return Modality.FINAL;
        }
        return Modality.convertFromFlags(psiClass.hasModifierProperty("abstract") || psiClass.isInterface(), !psiClass.hasModifierProperty("final"));
    }

    void checkFqNamesAreConsistent(@NotNull PsiClass psiClass, @NotNull FqName desiredFqName) {
        String qualifiedName = psiClass.getQualifiedName();
        assert (qualifiedName != null);
        FqName fqName = new FqName(qualifiedName);
        assert (fqName.equals(desiredFqName));
        FqNameUnsafe correctedName = JavaClassResolver.javaClassToKotlinFqName(fqName);
        if (this.classDescriptorCache.containsKey(correctedName) || this.unresolvedCache.contains(correctedName)) {
            throw new IllegalStateException(qualifiedName);
        }
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentDescriptor(@NotNull PsiClass psiClass) {
        if (JavaClassResolver.isContainedInClass(psiClass)) {
            return this.resolveParentClass(psiClass);
        }
        return this.resolveParentNamespace(psiClass);
    }

    @NotNull
    private static FqName getFqName(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        assert (qualifiedName != null);
        return new FqName(qualifiedName);
    }

    @NotNull
    private static FqNameUnsafe javaClassToKotlinFqName(@NotNull FqName rawFqName) {
        ArrayList<Name> correctedSegments = new ArrayList<Name>();
        for (Name segment : rawFqName.pathSegments()) {
            if ("object".equals(segment.asString())) {
                assert (!correctedSegments.isEmpty());
                Name previous = (Name)correctedSegments.get(correctedSegments.size() - 1);
                correctedSegments.add(DescriptorUtils.getClassObjectName(previous));
                continue;
            }
            correctedSegments.add(segment);
        }
        return new FqNameUnsafe(StringUtil.join(correctedSegments, "."));
    }

    private static boolean isContainedInClass(@NotNull PsiClass psiClass) {
        return psiClass.getContainingClass() != null;
    }

    private static boolean isInnerClass(@NotNull PsiClass psiClass) {
        return JavaClassResolver.isContainedInClass(psiClass) && !psiClass.hasModifierProperty("static");
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentClass(@NotNull PsiClass psiClass) {
        PsiClass containingClass = psiClass.getContainingClass();
        assert (containingClass != null);
        FqName containerFqName = JavaClassResolver.getFqName(containingClass);
        ClassDescriptor parentClass = this.resolveClass(containerFqName, DescriptorSearchRule.INCLUDE_KOTLIN);
        if (parentClass == null) {
            throw new IllegalStateException("PsiClass not found by name " + containerFqName + ", required to be container declaration of " + JavaClassResolver.getFqName(psiClass));
        }
        return parentClass;
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentNamespace(@NotNull PsiClass psiClass) {
        FqName namespaceFqName = JavaClassResolver.getFqName(psiClass).parent();
        NamespaceDescriptor parentNamespace = this.namespaceResolver.resolveNamespace(namespaceFqName, DescriptorSearchRule.INCLUDE_KOTLIN);
        if (parentNamespace == null) {
            throw new IllegalStateException("cannot resolve namespace " + namespaceFqName + ", required to be container for " + JavaClassResolver.getFqName(psiClass));
        }
        return parentNamespace;
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull PsiClass psiClass, @NotNull JetClassAnnotation jetClassAnnotation) {
        if (psiClass.isInterface()) {
            return psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT;
        }
        if (psiClass.isEnum()) {
            return ClassKind.ENUM_CLASS;
        }
        return jetClassAnnotation.kind() == 64 ? ClassKind.OBJECT : ClassKind.CLASS;
    }

    @Nullable
    public ClassDescriptor resolveClass(FqName name) {
        return this.resolveClass(name, DescriptorSearchRule.ERROR_IF_FOUND_IN_KOTLIN);
    }
}

