/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.ImmutableBiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMapBuilder;

public class CollectionClassMapping
extends JavaToKotlinClassMapBuilder {
    private static CollectionClassMapping instance = null;
    private ImmutableBiMap.Builder<ClassDescriptor, ClassDescriptor> mapBuilder = ImmutableBiMap.builder();
    private final ImmutableBiMap<ClassDescriptor, ClassDescriptor> mutableToReadOnlyMap;

    @NotNull
    public static CollectionClassMapping getInstance() {
        if (instance == null) {
            instance = new CollectionClassMapping();
        }
        return instance;
    }

    private CollectionClassMapping() {
        this.init();
        this.mutableToReadOnlyMap = this.mapBuilder.build();
        this.mapBuilder = null;
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        this.mapBuilder.put((Object)kotlinMutableDescriptor, (Object)kotlinDescriptor);
    }

    public boolean isMutableCollection(@NotNull ClassDescriptor mutable) {
        return this.mutableToReadOnlyMap.containsKey(mutable);
    }

    public boolean isReadOnlyCollection(@NotNull ClassDescriptor immutable) {
        return this.mutableToReadOnlyMap.containsValue(immutable);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        ClassDescriptor readOnly = (ClassDescriptor)this.mutableToReadOnlyMap.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        return readOnly;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        ClassDescriptor mutable = (ClassDescriptor)this.mutableToReadOnlyMap.inverse().get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        return mutable;
    }
}

