/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public class TypeConstraintsImpl
implements TypeConstraints {
    private final Variance varianceOfPosition;
    private final Set<JetType> upperBounds = Sets.newLinkedHashSet();
    private final Set<JetType> lowerBounds = Sets.newLinkedHashSet();
    private final Set<JetType> exactBounds = Sets.newLinkedHashSet();

    public TypeConstraintsImpl(Variance varianceOfPosition) {
        this.varianceOfPosition = varianceOfPosition;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public void addBound(@NotNull BoundKind boundKind, @NotNull JetType type) {
        switch (boundKind) {
            case LOWER_BOUND: {
                this.lowerBounds.add(type);
                break;
            }
            case UPPER_BOUND: {
                this.upperBounds.add(type);
                break;
            }
            case EXACT_BOUND: {
                this.exactBounds.add(type);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.upperBounds.isEmpty() && this.lowerBounds.isEmpty() && this.exactBounds.isEmpty();
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    @NotNull
    public Set<JetType> getExactBounds() {
        return this.exactBounds;
    }

    TypeConstraintsImpl copy() {
        TypeConstraintsImpl typeConstraints = new TypeConstraintsImpl(this.varianceOfPosition);
        typeConstraints.upperBounds.addAll(this.upperBounds);
        typeConstraints.lowerBounds.addAll(this.lowerBounds);
        typeConstraints.exactBounds.addAll(this.exactBounds);
        return typeConstraints;
    }

    public static enum BoundKind {
        LOWER_BOUND,
        UPPER_BOUND,
        EXACT_BOUND;

    }
}

