/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetObjectStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetObjectDeclaration
extends JetNamedDeclarationStub<PsiJetObjectStub>
implements JetClassOrObject {
    public JetObjectDeclaration(@NotNull ASTNode node) {
        super(node);
    }

    public JetObjectDeclaration(@NotNull PsiJetObjectStub stub) {
        super(stub, JetStubElementTypes.OBJECT_DECLARATION);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        return JetStubElementTypes.OBJECT_DECLARATION;
    }

    @Override
    public String getName() {
        PsiJetObjectStub stub = (PsiJetObjectStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getName();
    }

    public FqName getFqName() {
        PsiJetObjectStub stub = (PsiJetObjectStub)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return JetPsiUtil.getFQName(this);
    }

    public boolean isTopLevel() {
        PsiJetObjectStub stub = (PsiJetObjectStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof JetFile;
    }

    @Override
    public PsiElement getNameIdentifier() {
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getNameIdentifier();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.setName(name);
    }

    @Override
    @Nullable
    public JetObjectDeclarationName getNameAsDeclaration() {
        return (JetObjectDeclarationName)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        PsiElement parent = this.getParent();
        if (JetObjectDeclaration.isClassObject(parent)) {
            assert (parent instanceof JetDeclaration);
            return ((JetDeclaration)parent).getModifierList();
        }
        return (JetModifierList)this.findChildByType(JetNodeTypes.MODIFIER_LIST);
    }

    private static boolean isClassObject(@NotNull PsiElement parent) {
        return parent.getNode().getElementType().equals(JetNodeTypes.CLASS_OBJECT);
    }

    @Override
    public boolean hasModifier(JetToken modifier) {
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    @Nullable
    public JetDelegationSpecifierList getDelegationSpecifierList() {
        return (JetDelegationSpecifierList)this.findChildByType(JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetDelegationSpecifierList list = this.getDelegationSpecifierList();
        return list != null ? list.getDelegationSpecifiers() : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        JetClassBody body = (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getAnonymousInitializers();
    }

    @Override
    public boolean hasPrimaryConstructor() {
        return true;
    }

    @Override
    public JetClassBody getBody() {
        return (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getDeclarations();
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitObjectDeclaration(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitObjectDeclaration(this, data);
    }

    public boolean isObjectLiteral() {
        return this.getParent() instanceof JetObjectLiteralExpression;
    }

    @NotNull
    public PsiElement getObjectKeyword() {
        return this.findChildByType(JetTokens.OBJECT_KEYWORD);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        JetPsiUtil.deleteClass(this);
    }
}

