/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> mark(@NotNull E element) {
        return PositioningStrategy.markElement(element);
    }

    public boolean isValid(@NotNull E element) {
        return !PositioningStrategy.hasSyntaxErrors(element);
    }

    @NotNull
    protected static List<TextRange> markElement(@NotNull PsiElement element) {
        return Collections.singletonList(element.getTextRange());
    }

    @NotNull
    protected static List<TextRange> markNode(@NotNull ASTNode node) {
        return Collections.singletonList(node.getTextRange());
    }

    @NotNull
    protected static List<TextRange> markRange(@NotNull TextRange range) {
        return Collections.singletonList(range);
    }

    protected static boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement lastChild = psiElement.getLastChild();
        if (lastChild != null && PositioningStrategy.hasSyntaxErrors(lastChild)) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        return children.length > 0 && PositioningStrategy.hasSyntaxErrors(children[children.length - 1]);
    }
}

