/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;

public abstract class ClassBuilder {
    private String thisName;

    public FieldVisitor newField(@Nullable PsiElement origin, int access, String name, String desc, @Nullable String signature, @Nullable Object value) {
        return this.getVisitor().visitField(access, name, desc, signature, value);
    }

    public MethodVisitor newMethod(@Nullable PsiElement origin, int access, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
        return this.getVisitor().visitMethod(access, name, desc, signature, exceptions);
    }

    public AnnotationVisitor newAnnotation(String desc, boolean visible) {
        return this.getVisitor().visitAnnotation(desc, visible);
    }

    public void done() {
        this.getVisitor().visitEnd();
    }

    public abstract ClassVisitor getVisitor();

    public void defineClass(PsiElement origin, int version, int access, String name, @Nullable String signature, String superName, String[] interfaces) {
        this.thisName = name;
        this.getVisitor().visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String name, @Nullable String debug) {
        this.getVisitor().visitSource(name, debug);
    }

    public void visitOuterClass(String owner, @Nullable String name, @Nullable String desc) {
        this.getVisitor().visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.getVisitor().visitInnerClass(name, outerName, innerName, access);
    }

    public String getThisName() {
        return this.thisName;
    }

    public static class Concrete
    extends ClassBuilder {
        private final ClassVisitor v;

        public Concrete(ClassVisitor v) {
            this.v = v;
        }

        @Override
        public ClassVisitor getVisitor() {
            return this.v;
        }
    }
}

