/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.FloatIterator;
import jet.FloatProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class FloatRange
implements Progression<Float>,
Range<Float> {
    public static final FloatRange EMPTY = new FloatRange(1.0f, 0.0f);
    private final float start;
    private final float end;

    public FloatRange(float start, float end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Float item) {
        return this.start <= item.floatValue() && item.floatValue() <= this.end;
    }

    @Override
    public boolean contains(float item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Float getStart() {
        return Float.valueOf(this.start);
    }

    @Override
    public Float getEnd() {
        return Float.valueOf(this.end);
    }

    @Override
    public Float getIncrement() {
        return Float.valueOf(1.0f);
    }

    public FloatIterator iterator() {
        return new FloatProgressionIterator(this.start, this.end, 1.0f);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatRange range = (FloatRange)o;
        return Float.compare(range.end, this.end) == 0 && Float.compare(range.start, this.start) == 0;
    }

    public int hashCode() {
        int result = this.start != 0.0f ? Float.floatToIntBits(this.start) : 0;
        result = 31 * result + (this.end != 0.0f ? Float.floatToIntBits(this.end) : 0);
        return result;
    }
}

