/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){};

    private XmlSerializer() {
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            Binding binding = XmlSerializerImpl.getBinding(bean.getClass());
            assert (binding instanceof BeanBinding);
            ((BeanBinding)binding).deserializeInto(bean, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

