/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer;
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId;
    private final RecentStringInterner myStringInterner;

    public StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage) {
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "<init>"));
        }
        this.myIdToSerializer = new TIntObjectHashMap();
        this.mySerializerToId = new TObjectIntHashMap();
        this.myStringInterner = new RecentStringInterner();
        this.myNameStorage = nameStorage;
    }

    public void assignId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "assignId"));
        }
        int id = this.persistentId(serializer);
        ObjectStubSerializer old = this.myIdToSerializer.put(id, serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put(serializer, id);
        assert (oldId == 0) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "persistentId"));
        }
        return this.myNameStorage.enumerate(serializer.getExternalId());
    }

    private void doSerialize(@NotNull Stub rootStub, @NotNull StubOutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer(rootStub);
        DataInputOutputUtil.writeINT(stream, this.getClassId(serializer));
        serializer.serialize(rootStub, stream);
        List<? extends Stub> children = rootStub.getChildrenStubs();
        int childrenSize = children.size();
        DataInputOutputUtil.writeINT(stream, childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            this.doSerialize(children.get(i), stream);
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator();
        StubOutputStream stubOutputStream = new StubOutputStream(out, storage);
        this.doSerialize(rootStub, stubOutputStream);
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT(resultStream, storage.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage.myStrings) {
            IOUtil.writeUTFFast(buffer, resultStream, s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        int idValue = this.mySerializerToId.get(serializer);
        assert (idValue != 0) : "No ID found for serializer " + LogUtil.objectAndClass(serializer);
        return idValue;
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator();
        StubInputStream inputStream = new StubInputStream(stream, storage);
        int size = DataInputOutputUtil.readINT(inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (int i = 1; i <= size; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast(buffer, inputStream));
            storage.myStrings.add(s);
            storage.myEnumerates.put(s, i);
        }
        Stub stub = this.deserialize(inputStream, null);
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return stub;
    }

    @NotNull
    private Stub deserialize(@NotNull StubInputStream stream, @Nullable Stub parentStub) throws IOException, SerializerNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        int id = DataInputOutputUtil.readINT(stream);
        ObjectStubSerializer serializer = this.getClassById(id);
        if (serializer == null) {
            throw new SerializerNotFoundException("No serializer registered for stub: ID=" + id + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() : "null"));
        }
        Object stub = serializer.deserialize(stream, parentStub);
        int childCount = DataInputOutputUtil.readINT(stream);
        for (int i = 0; i < childCount; ++i) {
            this.deserialize(stream, (Stub)stub);
        }
        Object t = stub;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return t;
    }

    private ObjectStubSerializer getClassById(int id) {
        return this.myIdToSerializer.get(id);
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates = new TObjectIntHashMap();
        private final ArrayList<String> myStrings = new ArrayList();

        private FileLocalStringEnumerator() {
        }

        @Override
        public int enumerate(@Nullable String value) throws IOException {
            if (value == null) {
                return 0;
            }
            int i = this.myEnumerates.get(value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put(value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        @Override
        public String valueOf(int idx) throws IOException {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        @Override
        public void markCorrupted() {
        }

        @Override
        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

