/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this(list, list.getExpressionTypes());
    }

    public JavaMethodsConflictResolver(PsiElement argumentsList, PsiType[] actualParameterTypes) {
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
    }

    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "resolveConflict"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        int applicabilityLevel = JavaMethodsConflictResolver.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkLambdaApplicable(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSpecifics(conflicts, applicabilityLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.myActualParameterTypes.length);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet<CandidateInfo> uniques = new THashSet<CandidateInfo>(conflicts);
        if (uniques.size() == 1) {
            return uniques.iterator().next();
        }
        return null;
    }

    private void checkLambdaApplicable(List<CandidateInfo> conflicts) {
        if (!PsiUtil.isLanguageLevel8OrHigher(this.myArgumentsList)) {
            return;
        }
        for (int i = 0; i < this.myActualParameterTypes.length; ++i) {
            PsiType parameterType = this.myActualParameterTypes[i];
            if (!(parameterType instanceof PsiLambdaExpressionType)) continue;
            PsiLambdaExpression lambdaExpression = ((PsiLambdaExpressionType)parameterType).getExpression();
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                PsiParameter[] methodParameters;
                ProgressManager.checkCanceled();
                CandidateInfo conflict = iterator.next();
                PsiMethod method = (PsiMethod)conflict.getElement();
                if (method == null || (methodParameters = method.getParameterList().getParameters()).length == 0) continue;
                PsiParameter param = i < methodParameters.length ? methodParameters[i] : methodParameters[methodParameters.length - 1];
                PsiType paramType = param.getType();
                if (LambdaUtil.isAcceptable(lambdaExpression, conflict.getSubstitutor().substitute(paramType), true)) continue;
                iterator.remove();
            }
        }
        LambdaUtil.checkMoreSpecificReturnType(conflicts, this.myActualParameterTypes);
    }

    public void checkSpecifics(List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    assert (conflict != method);
                    switch (this.isMoreSpecific(method, conflict, applicabilityLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    private static void checkAccessStaticLevels(List<CandidateInfo> conflicts, boolean checkAccessible) {
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    private void checkSameSignatures(List<CandidateInfo> conflicts) {
        PsiMethod method;
        THashMap<MethodSignature, CandidateInfo> signatures = new THashMap<MethodSignature, CandidateInfo>(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        for (CandidateInfo conflict : conflicts) {
            method = ((MethodCandidateInfo)conflict).getElement();
            for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if ("java.lang.Object".equals(superMethod.getContainingClass().getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        block2: for (int i = 0; i < conflicts.size(); ++i) {
            PsiReferenceExpression expression;
            PsiExpression qualifierExpression;
            PsiClass currentClass;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            method = (PsiMethod)info.getElement();
            assert (method != null);
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = info.getSubstitutor();
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            assert (existingMethod != null);
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                signatures.put(signature, info);
                continue;
            }
            if (method == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor(scope1, scope2, true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method, existingMethod)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) {
                signatures.put(signature, info);
                int index = conflicts.indexOf(existing);
                conflicts.remove(index);
                --i;
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf(class1, existingClass, true) || InheritanceUtil.isInheritorOrSelf(existingClass, class1, true)) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
                int parametersLength = parameters.length;
                for (int i1 = 0; i1 < parametersLength; ++i1) {
                    if (!(parameters[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                    signatures.put(signature, info);
                    continue block2;
                }
                PsiType returnType1 = method.getReturnType();
                PsiType returnType2 = existingMethod.getReturnType();
                if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = existing.getSubstitutor().substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                    conflicts.remove(i);
                    --i;
                    continue;
                }
                signatures.put(signature, info);
                continue;
            }
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(this.myArgumentsList, PsiMethodCallExpression.class);
            if (methodCallExpression == null || (currentClass = (qualifierExpression = (expression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null ? PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType()) : PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null || !InheritanceUtil.isInheritorOrSelf(currentClass, class1, true) || !InheritanceUtil.isInheritorOrSelf(currentClass, existingClass, true)) continue;
            PsiSubstitutor eSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(existingClass, currentClass, PsiSubstitutor.EMPTY);
            PsiSubstitutor cSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(class1, currentClass, PsiSubstitutor.EMPTY);
            if (!MethodSignatureUtil.areSignaturesEqual(existingMethod.getSignature(eSubstitutor), method.getSignature(cSubstitutor))) continue;
            PsiType returnType = eSubstitutor.substitute(existingMethod.getReturnType());
            PsiType returnType1 = cSubstitutor.substitute(method.getReturnType());
            if (returnType != null && returnType1 != null && !returnType1.equals(returnType) && TypeConversionUtil.isAssignable(returnType, returnType1, false)) {
                if (class1.isInterface() && !existingClass.isInterface()) continue;
                conflicts.remove(existing);
            } else {
                conflicts.remove(i);
            }
            --i;
            break;
        }
    }

    private static boolean areTypeParametersAgree(CandidateInfo info) {
        return ((MethodCandidateInfo)info).isApplicable();
    }

    private static boolean checkParametersNumber(List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            if (method.isVarArgs()) {
                return true;
            }
            if (method.getParameterList().getParametersCount() == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index = unmatchedIndices.get(u);
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    private static int checkApplicability(List<CandidateInfo> conflicts) {
        int level;
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = JavaMethodsConflictResolver.preferVarargs((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = JavaMethodsConflictResolver.preferVarargs(info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    private static int preferVarargs(CandidateInfo info) {
        PsiMethod psiMethod;
        int level = ((MethodCandidateInfo)info).getApplicabilityLevel();
        if (level == 3 && (psiMethod = (PsiMethod)info.getElement()) != null && psiMethod.isVarArgs() && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7)) {
            return level + 1;
        }
        return level;
    }

    private static int getCheckAccessLevel(MethodCandidateInfo method) {
        boolean visible = method.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(MethodCandidateInfo method) {
        boolean available = method.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private static Specifics checkSubtyping(PsiType type1, PsiType type2, PsiMethod method1, PsiMethod method2) {
        return JavaMethodsConflictResolver.checkSubtyping(type1, type2, method1, method2, true);
    }

    @Nullable
    private static Specifics checkSubtyping(PsiType type1, PsiType type2, PsiMethod method1, PsiMethod method2, boolean boxingHappening) {
        boolean assignable1From2;
        boolean allowUncheckedConversion;
        boolean noBoxing = boxingHappening || type1 instanceof PsiPrimitiveType == type2 instanceof PsiPrimitiveType;
        boolean bl = allowUncheckedConversion = !method1.hasModifierProperty("static") && !method2.hasModifierProperty("static");
        if (!allowUncheckedConversion) {
            PsiClass containingClass1 = method1.getContainingClass();
            PsiClass containingClass2 = method2.getContainingClass();
            if (containingClass1 != null && containingClass2 != null) {
                allowUncheckedConversion = !containingClass1.isInheritor(containingClass2, true) && !containingClass2.isInheritor(containingClass1, true);
            }
        }
        boolean assignable2From1 = noBoxing && TypeConversionUtil.isAssignable(type2, type1, allowUncheckedConversion);
        boolean bl2 = assignable1From2 = noBoxing && TypeConversionUtil.isAssignable(type1, type2, allowUncheckedConversion);
        if (assignable1From2 || assignable2From1) {
            if (assignable1From2 && assignable2From1) {
                return null;
            }
            return assignable1From2 ? Specifics.SECOND : Specifics.FIRST;
        }
        return allowUncheckedConversion ? Specifics.NEITHER : null;
    }

    private boolean isBoxingHappened(PsiType argType, PsiType parameterType) {
        if (argType == null) {
            return parameterType instanceof PsiPrimitiveType;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(this.myArgumentsList);
        if (parameterType instanceof PsiClassType) {
            parameterType = ((PsiClassType)parameterType).setLanguageLevel(languageLevel);
        }
        return TypeConversionUtil.boxingConversionApplicable(parameterType, argType);
    }

    private Specifics isMoreSpecific(CandidateInfo info1, CandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        PsiMethod method1 = (PsiMethod)info1.getElement();
        PsiMethod method2 = (PsiMethod)info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = info1.getSubstitutor();
        PsiSubstitutor classSubstitutor2 = info2.getSubstitutor();
        int max = Math.max(params1.length, params2.length);
        PsiType[] types1 = new PsiType[max];
        PsiType[] types2 = new PsiType[max];
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (applicabilityLevel == 2) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && (!JavaVersionService.getInstance().isAtLeast(class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        int[] boxingHappened = new int[2];
        for (int i = 0; i < types1.length; ++i) {
            ProgressManager.checkCanceled();
            PsiType type1 = classSubstitutor1.substitute(types1[i]);
            PsiType type2 = classSubstitutor2.substitute(types2[i]);
            PsiType argType = i < this.myActualParameterTypes.length ? this.myActualParameterTypes[i] : null;
            boxingHappened[0] = boxingHappened[0] + (this.isBoxingHappened(argType, type1) ? 1 : 0);
            boxingHappened[1] = boxingHappened[1] + (this.isBoxingHappened(argType, type2) ? 1 : 0);
        }
        if (boxingHappened[0] == 0 && boxingHappened[1] > 0) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] > 0 && boxingHappened[1] == 0) {
            return Specifics.SECOND;
        }
        Specifics isMoreSpecific = null;
        block7: for (int i = 0; i < types1.length; ++i) {
            ProgressManager.checkCanceled();
            Specifics specifics = JavaMethodsConflictResolver.checkSubstitutorSpecific(method1, method2, classSubstitutor1, classSubstitutor2, types1[i], types2[i]);
            if (specifics == null) {
                PsiSubstitutor methodSubstitutor1 = PsiSubstitutor.EMPTY;
                PsiSubstitutor methodSubstitutor2 = PsiSubstitutor.EMPTY;
                if (typeParameters1.length == 0 || typeParameters2.length == 0) {
                    PsiResolveHelper resolveHelper;
                    if (typeParameters1.length > 0) {
                        resolveHelper = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getResolveHelper();
                        methodSubstitutor1 = this.calculateMethodSubstitutor(typeParameters1, types1, types2, resolveHelper);
                    } else if (typeParameters2.length > 0) {
                        resolveHelper = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getResolveHelper();
                        methodSubstitutor2 = this.calculateMethodSubstitutor(typeParameters2, types2, types1, resolveHelper);
                    }
                } else {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getElementFactory();
                    methodSubstitutor1 = factory.createRawSubstitutor(PsiSubstitutor.EMPTY, typeParameters1);
                    methodSubstitutor2 = factory.createRawSubstitutor(PsiSubstitutor.EMPTY, typeParameters2);
                }
                PsiType type1 = classSubstitutor1.substitute(methodSubstitutor1.substitute(types1[i]));
                PsiType type2 = classSubstitutor2.substitute(methodSubstitutor2.substitute(types2[i]));
                Specifics specifics2 = type1 == null || type2 == null ? null : (specifics = JavaMethodsConflictResolver.checkSubtyping(type1, type2, method1, method2, boxingHappened[0] == 0 || boxingHappened[1] == 0));
                if (specifics == null) continue;
            }
            switch (specifics) {
                case FIRST: {
                    if (isMoreSpecific == Specifics.SECOND) {
                        return Specifics.NEITHER;
                    }
                    isMoreSpecific = specifics;
                    continue block7;
                }
                case SECOND: {
                    if (isMoreSpecific == Specifics.FIRST) {
                        return Specifics.NEITHER;
                    }
                    isMoreSpecific = specifics;
                    continue block7;
                }
                case NEITHER: {
                    return Specifics.NEITHER;
                }
            }
        }
        if (isMoreSpecific == null && class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature(method1.getSignature(info1.getSubstitutor()), method2.getSignature(info2.getSubstitutor()))) {
                    isMoreSpecific = Specifics.SECOND;
                } else if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    isMoreSpecific = Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) || class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature(method2.getSignature(info2.getSubstitutor()), method1.getSignature(info1.getSubstitutor()))) {
                    isMoreSpecific = Specifics.FIRST;
                } else if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    isMoreSpecific = Specifics.FIRST;
                }
            }
        }
        if (isMoreSpecific == null) {
            if (!JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7) || !MethodSignatureUtil.areParametersErasureEqual(method1, method2) || InheritanceUtil.isInheritorOrSelf(class1, class2, true) || InheritanceUtil.isInheritorOrSelf(class2, class1, true)) {
                if (typeParameters1.length < typeParameters2.length) {
                    return Specifics.FIRST;
                }
                if (typeParameters1.length > typeParameters2.length) {
                    return Specifics.SECOND;
                }
            }
            return Specifics.NEITHER;
        }
        return isMoreSpecific;
    }

    @Nullable
    private static Specifics checkSubstitutorSpecific(PsiMethod method1, PsiMethod method2, PsiSubstitutor classSubstitutor1, PsiSubstitutor classSubstitutor2, PsiType type1, PsiType type2) {
        PsiClass aClass1 = PsiUtil.resolveClassInType(type1);
        PsiClass aClass2 = PsiUtil.resolveClassInType(type2);
        if (aClass1 instanceof PsiTypeParameter && aClass2 instanceof PsiTypeParameter) {
            return JavaMethodsConflictResolver.checkTypeParams(method1, method2, classSubstitutor1, classSubstitutor2, type1, type2, (PsiTypeParameter)aClass1, (PsiTypeParameter)aClass2);
        }
        if (aClass1 instanceof PsiTypeParameter && aClass2 != null) {
            return JavaMethodsConflictResolver.chooseHigherDimension(type1, type2);
        }
        if (aClass2 instanceof PsiTypeParameter && aClass1 != null) {
            return JavaMethodsConflictResolver.chooseHigherDimension(type2, type1);
        }
        Map<PsiTypeParameter, PsiType> map1 = classSubstitutor1.getSubstitutionMap();
        Map<PsiTypeParameter, PsiType> map2 = classSubstitutor2.getSubstitutionMap();
        if (map1.size() == 1 && map2.size() == 1) {
            PsiTypeParameter p2;
            boolean raw2;
            PsiType t1 = map1.values().iterator().next();
            PsiType t2 = map2.values().iterator().next();
            boolean raw1 = t1 instanceof PsiClassType && ((PsiClassType)t1).hasParameters();
            boolean bl = raw2 = t2 instanceof PsiClassType && ((PsiClassType)t2).hasParameters();
            if (!raw1 && raw2) {
                return Specifics.FIRST;
            }
            if (raw1 && !raw2) {
                return Specifics.SECOND;
            }
            PsiTypeParameter p1 = map1.keySet().iterator().next();
            Specifics specifics = JavaMethodsConflictResolver.checkTypeParams(method1, method2, classSubstitutor1, classSubstitutor2, type1, type2, p1, p2 = map2.keySet().iterator().next());
            if (specifics != null) {
                return specifics;
            }
            return JavaMethodsConflictResolver.chooseHigherDimension(t1, t2);
        }
        return null;
    }

    private static Specifics chooseHigherDimension(PsiType type1, PsiType type2) {
        int d2;
        if (type1 != null && type1.equalsToText("java.lang.Object")) {
            return null;
        }
        if (type2 != null && type2.equalsToText("java.lang.Object")) {
            return null;
        }
        int d1 = type1 != null ? type1.getArrayDimensions() : 0;
        int n = d2 = type2 != null ? type2.getArrayDimensions() : 0;
        if (d1 > d2) {
            return Specifics.SECOND;
        }
        if (d2 > d1) {
            return Specifics.FIRST;
        }
        return null;
    }

    @Nullable
    private static Specifics checkTypeParams(PsiMethod method1, PsiMethod method2, PsiSubstitutor classSubstitutor1, PsiSubstitutor classSubstitutor2, PsiType type1, PsiType type2, PsiTypeParameter p1, PsiTypeParameter p2) {
        HashMap<PsiClass, PsiClassType> resolved1 = new HashMap<PsiClass, PsiClassType>();
        for (PsiClassType referenceElement : p1.getExtendsList().getReferencedTypes()) {
            ProgressManager.checkCanceled();
            PsiClass aClass = referenceElement.resolve();
            if (aClass == null) continue;
            resolved1.put(aClass, referenceElement);
        }
        HashMap<PsiClass, PsiClassType> resolved2 = new HashMap<PsiClass, PsiClassType>();
        for (PsiClassType referenceElement : p2.getExtendsList().getReferencedTypes()) {
            ProgressManager.checkCanceled();
            PsiClass aClass = referenceElement.resolve();
            if (aClass == null) continue;
            resolved2.put(aClass, referenceElement);
        }
        Specifics specifics = null;
        if (resolved1.size() > resolved2.size()) {
            specifics = JavaMethodsConflictResolver.checkExtendsList(resolved1, resolved2, Specifics.FIRST);
        } else if (resolved2.size() > resolved1.size()) {
            specifics = JavaMethodsConflictResolver.checkExtendsList(resolved2, resolved1, Specifics.SECOND);
        }
        if (specifics != null) {
            return specifics;
        }
        specifics = JavaMethodsConflictResolver.checkSubtyping(TypeConversionUtil.erasure(PsiSubstitutor.EMPTY.substitute(p1)), TypeConversionUtil.erasure(PsiSubstitutor.EMPTY.substitute(p2)), method1, method2);
        if (specifics != null) {
            return specifics;
        }
        PsiType ctype1 = classSubstitutor1.substitute(type1);
        PsiType ctype2 = classSubstitutor2.substitute(type2);
        return JavaMethodsConflictResolver.checkSubtyping(ctype1, ctype2, method1, method2);
    }

    private static Specifics checkExtendsList(Map<PsiClass, PsiClassType> resolved1, Map<PsiClass, PsiClassType> resolved2, Specifics preferred) {
        if (resolved1.keySet().containsAll(resolved2.keySet())) {
            resolved1.keySet().removeAll(resolved2.keySet());
            Iterator<PsiClass> iterator = resolved1.keySet().iterator();
            block0: while (iterator.hasNext()) {
                PsiClass psiClass = iterator.next();
                PsiClassType baseType = resolved1.get(psiClass);
                for (PsiClassType childType : resolved2.values()) {
                    ProgressManager.checkCanceled();
                    if (!TypeConversionUtil.isAssignable(baseType, childType, false)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            if (!resolved1.isEmpty()) {
                return preferred;
            }
            return Specifics.NEITHER;
        }
        return null;
    }

    private PsiSubstitutor calculateMethodSubstitutor(PsiTypeParameter[] typeParameters, PsiType[] types1, PsiType[] types2, PsiResolveHelper resolveHelper) {
        PsiSubstitutor substitutor = resolveHelper.inferTypeArguments(typeParameters, types1, types2, PsiUtil.getLanguageLevel(this.myArgumentsList));
        for (PsiTypeParameter typeParameter : typeParameters) {
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (substitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, TypeConversionUtil.typeParameterErasure(typeParameter));
        }
        return substitutor;
    }

    public void checkPrimitiveVarargs(List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method;
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || method == null || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

