/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiType;

public interface JavaCodeFragment
extends PsiCodeFragment,
PsiImportHolder {
    public PsiType getThisType();

    public void setThisType(PsiType var1);

    public PsiType getSuperType();

    public void setSuperType(PsiType var1);

    public String importsToString();

    public void addImportsFromString(String var1);

    public void setVisibilityChecker(VisibilityChecker var1);

    public VisibilityChecker getVisibilityChecker();

    public void setExceptionHandler(ExceptionHandler var1);

    public ExceptionHandler getExceptionHandler();

    public static interface ExceptionHandler {
        public boolean isHandledException(PsiClassType var1);
    }

    public static interface VisibilityChecker {
        public static final VisibilityChecker EVERYTHING_VISIBLE = new VisibilityChecker(){

            @Override
            public Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                return Visibility.VISIBLE;
            }
        };
        public static final VisibilityChecker PROJECT_SCOPE_VISIBLE = new VisibilityChecker(){

            @Override
            public Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                return declaration.getManager().isInProject(declaration) ? Visibility.VISIBLE : Visibility.NOT_VISIBLE;
            }
        };

        public Visibility isDeclarationVisible(PsiElement var1, PsiElement var2);

        public static enum Visibility {
            VISIBLE,
            NOT_VISIBLE,
            DEFAULT_VISIBILITY;

        }
    }
}

