/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t) {
                ourFactory = new JavaFactory();
            }
        }
        return ourFactory;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull @NonNls String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        LoggerRt loggerRt = LoggerRt.getFactory().getInstance(category);
        if (loggerRt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        return loggerRt;
    }

    private static class IdeaFactory
    implements Factory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        @Override
        public LoggerRt getInstance(@NotNull @NonNls String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/LoggerRt$IdeaFactory", "getInstance"));
            }
            try {
                final Object logger = this.myGetInstance.invoke(null, category);
                return new LoggerRt(){};
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class JavaFactory
    implements Factory {
        private final LogManager myManager = LogManager.getLogManager();

        private JavaFactory() {
        }

        @Override
        public LoggerRt getInstance(@NotNull @NonNls String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/LoggerRt$JavaFactory", "getInstance"));
            }
            final Logger logger = this.myManager.getLogger(category);
            return new LoggerRt(){};
        }
    }

    private static interface Factory {
        public LoggerRt getInstance(@NotNull @NonNls String var1);
    }
}

