/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.collect.Sets;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class NumberConversionFIF
extends CompositeFIF {
    @NotNull
    private static final NamePredicate SUPPORTED_CONVERSIONS;
    @NotNull
    private static final NamePredicate FLOATING_POINT_CONVERSIONS;
    @NotNull
    private static final NamePredicate INTEGER_CONVERSIONS;
    @NotNull
    private static final FunctionIntrinsic RETURN_RECEIVER;
    @NotNull
    public static final String INTEGER_NUMBER_TYPES = "Int|Byte|Short";
    @NotNull
    private static final FunctionIntrinsic GET_INTEGER_PART;
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE;

    private NumberConversionFIF() {
        this.add(PatternBuilder.pattern(INTEGER_NUMBER_TYPES, SUPPORTED_CONVERSIONS), RETURN_RECEIVER);
        this.add(PatternBuilder.pattern("Float|Double|Number", INTEGER_CONVERSIONS), GET_INTEGER_PART);
        this.add(PatternBuilder.pattern("Float|Double|Number", FLOATING_POINT_CONVERSIONS), RETURN_RECEIVER);
    }

    static {
        HashSet<Name> supportedConversions = Sets.newHashSet(OperatorConventions.NUMBER_CONVERSIONS);
        supportedConversions.remove(OperatorConventions.CHAR);
        supportedConversions.remove(OperatorConventions.LONG);
        SUPPORTED_CONVERSIONS = new NamePredicate(supportedConversions);
        FLOATING_POINT_CONVERSIONS = new NamePredicate(OperatorConventions.FLOAT, OperatorConventions.DOUBLE);
        INTEGER_CONVERSIONS = new NamePredicate(OperatorConventions.INT, OperatorConventions.SHORT, OperatorConventions.BYTE);
        RETURN_RECEIVER = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$1", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$1", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.isEmpty());
                JsExpression jsExpression = receiver;
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$1", "apply"));
                }
                return jsExpression;
            }
        };
        GET_INTEGER_PART = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$2", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$2", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.isEmpty());
                JsNameRef toConvertReference = context.declareTemporary(null).reference();
                JsBinaryOperation fractional = new JsBinaryOperation(JsBinaryOperator.MOD, toConvertReference, context.program().getNumberLiteral(1));
                JsBinaryOperation jsBinaryOperation = JsAstUtils.subtract(JsAstUtils.assignment(toConvertReference, receiver), fractional);
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/NumberConversionFIF$2", "apply"));
                }
                return jsBinaryOperation;
            }
        };
        INSTANCE = new NumberConversionFIF();
    }
}

