/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.k2js.translate.context.generator.Rule;

public class Generator<V> {
    @NotNull
    private final Map<DeclarationDescriptor, V> values = Maps.newHashMap();
    @NotNull
    private final List<Rule<V>> rules = Lists.newArrayList();

    public void addRule(@NotNull Rule<V> rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "org/jetbrains/k2js/translate/context/generator/Generator", "addRule"));
        }
        this.rules.add(rule);
    }

    @Nullable
    public V get(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/generator/Generator", "get"));
        }
        V result = this.values.get(descriptor);
        if (result != null) {
            return result;
        }
        result = this.generate(descriptor);
        this.values.put(descriptor, result);
        return result;
    }

    @Nullable
    private V generate(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/generator/Generator", "generate"));
        }
        for (Rule<V> rule : this.rules) {
            V result = rule.apply(descriptor);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

