/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;

public class AliasingContext {
    private static final AliasingContext ROOT = new AliasingContext(null){

        @Override
        protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext$1", "getAliasForDescriptor"));
            }
            return null;
        }

        @Override
        public JsExpression getAliasForExpression(@NotNull JetExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/context/AliasingContext$1", "getAliasForExpression"));
            }
            return null;
        }

        @Override
        public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext$1", "registerAlias"));
            }
            if (alias == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/k2js/translate/context/AliasingContext$1", "registerAlias"));
            }
            throw new IllegalStateException();
        }
    };
    @Nullable
    private Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<JetExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(ROOT);
    }

    AliasingContext(@Nullable AliasingContext parent) {
        this(parent, null, null);
    }

    private AliasingContext(@Nullable AliasingContext parent, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<JetExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext", "inner"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/k2js/translate/context/AliasingContext", "inner"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, Collections.singletonMap(descriptor, alias), null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/AliasingContext", "inner"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext notShareableThisAliased(final @NotNull DeclarationDescriptor thisDescriptor, final @NotNull JsExpression alias) {
        if (thisDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisDescriptor", "org/jetbrains/k2js/translate/context/AliasingContext", "notShareableThisAliased"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/k2js/translate/context/AliasingContext", "notShareableThisAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this){

            @Override
            @Nullable
            protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext$2", "getAliasForDescriptor"));
                }
                if (!fromChild && thisDescriptor == descriptor) {
                    return alias;
                }
                return super.getAliasForDescriptor(descriptor, fromChild);
            }
        };
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/AliasingContext", "notShareableThisAliased"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<JetExpression, JsExpression> aliasesForExpressions) {
        if (aliasesForExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasesForExpressions", "org/jetbrains/k2js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, null, aliasesForExpressions);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/k2js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, aliases, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        return aliasingContext;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext", "getAliasForDescriptor"));
        }
        return this.getAliasForDescriptor(descriptor, false);
    }

    @Nullable
    protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext", "getAliasForDescriptor"));
        }
        JsExpression alias = this.aliasesForDescriptors == null ? null : this.aliasesForDescriptors.get(descriptor.getOriginal());
        return alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor, true);
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull JetExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/context/AliasingContext", "getAliasForExpression"));
        }
        JsExpression alias = this.aliasesForExpressions == null ? null : this.aliasesForExpressions.get(element);
        return alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
    }

    public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/AliasingContext", "registerAlias"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/k2js/translate/context/AliasingContext", "registerAlias"));
        }
        if (this.aliasesForDescriptors == null) {
            this.aliasesForDescriptors = Collections.singletonMap(descriptor, alias);
        } else {
            if (this.aliasesForDescriptors.size() == 1) {
                Map<DeclarationDescriptor, JsExpression> singletonMap = this.aliasesForDescriptors;
                this.aliasesForDescriptors = new THashMap<DeclarationDescriptor, JsExpression>();
                this.aliasesForDescriptors.put(singletonMap.keySet().iterator().next(), singletonMap.values().iterator().next());
            }
            JsExpression prev = this.aliasesForDescriptors.put(descriptor, alias);
            assert (prev == null) : "Alias for descriptor already registered. Descriptor: " + descriptor + " prev alias: " + prev + " new alias: " + alias;
        }
    }
}

