/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.PackageType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.error.ErrorClassDescriptor;
import org.jetbrains.jet.lang.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.Printer;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptorImpl(Name.special("<ERROR MODULE>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor("");
    private static final JetType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final VariableDescriptor ERROR_PROPERTY = new PropertyDescriptorImpl(ERROR_CLASS, Annotations.EMPTY, Modality.OPEN, Visibilities.INTERNAL, true, null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Name.special("<ERROR PROPERTY>"), ERROR_PROPERTY_TYPE, CallableMemberDescriptor.Kind.DECLARATION);
    private static final Set<VariableDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/types/ErrorUtils", "containsErrorType"));
        }
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorScope"));
        }
        JetScope jetScope = ErrorUtils.createErrorScope(debugMessage, false);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorScope"));
        }
        return jetScope;
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorScope"));
        }
        if (throwExceptions) {
            ThrowingScope throwingScope = new ThrowingScope(debugMessage);
            if (throwingScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorScope"));
            }
            return throwingScope;
        }
        ErrorScope errorScope = new ErrorScope(debugMessage);
        if (errorScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorScope"));
        }
        return errorScope;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        if (ownerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerScope", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorFunction"));
        }
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ownerScope);
        function.initialize((JetType)null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), Collections.emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL);
        ErrorSimpleFunctionDescriptorImpl errorSimpleFunctionDescriptorImpl = function;
        if (errorSimpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorFunction"));
        }
        return errorSimpleFunctionDescriptorImpl;
    }

    @NotNull
    public static JetType createErrorType(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorType"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorType"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static JetType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName), ErrorUtils.createErrorScope(debugName));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        TypeConstructor typeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]");
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        return typeConstructor;
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl(ERROR_CLASS, Annotations.EMPTY, false, debugName, Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        return typeConstructorImpl;
    }

    @NotNull
    public static ClassDescriptor getErrorClass() {
        ErrorClassDescriptor errorClassDescriptor = ERROR_CLASS;
        if (errorClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "getErrorClass"));
        }
        return errorClassDescriptor;
    }

    public static boolean containsErrorType(@Nullable JetType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PackageType) {
            return false;
        }
        if (type.isError()) {
            return true;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (!ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/types/ErrorUtils", "isError"));
        }
        return ErrorUtils.isErrorClass(candidate) || ErrorUtils.isErrorClass(candidate.getContainingDeclaration()) || candidate == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static TypeParameterDescriptor createErrorTypeParameter(int index, @NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeParameter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound(ERROR_CLASS, Annotations.EMPTY, false, Variance.INVARIANT, Name.special("<ERROR: " + debugMessage + ">"), index);
        if (typeParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "createErrorTypeParameter"));
        }
        return typeParameterDescriptor;
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        ModuleDescriptor moduleDescriptor = ERROR_MODULE;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils", "getErrorModule"));
        }
        return moduleDescriptor;
    }

    private ErrorUtils() {
    }

    private static class ErrorTypeImpl
    implements JetType {
        private final TypeConstructor constructor;
        private final JetScope memberScope;

        private ErrorTypeImpl(@NotNull TypeConstructor constructor, @NotNull JetScope memberScope) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (memberScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            this.constructor = constructor;
            this.memberScope = memberScope;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor = this.constructor;
            if (typeConstructor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "getConstructor"));
            }
            return typeConstructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "getArguments"));
            }
            return list2;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            JetScope jetScope = this.memberScope;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "getMemberScope"));
            }
            return jetScope;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorTypeImpl", "getAnnotations"));
            }
            return annotations;
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    private static class ThrowingScope
    implements JetScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "<init>"));
            }
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getClassifier"));
            }
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getPackage"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getProperties"));
            }
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getLocalVariable"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getFunctions"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            ModuleDescriptor moduleDescriptor = ERROR_MODULE;
            if (moduleDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getContainingDeclaration"));
            }
            return moduleDescriptor;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "getDeclarationsByLabel"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/types/ErrorUtils$ThrowingScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements JetScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            if (debugMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "<init>"));
            }
            this.debugMessage = debugMessage;
        }

        @Override
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getClassifier"));
            }
            return ERROR_CLASS;
        }

        @NotNull
        public Set<VariableDescriptor> getProperties(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getProperties"));
            }
            Set set = ERROR_PROPERTY_GROUP;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getProperties"));
            }
            return set;
        }

        @Override
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getLocalVariable"));
            }
            return ERROR_PROPERTY;
        }

        @Override
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getPackage"));
            }
            return null;
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            List<ReceiverParameterDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getImplicitReceiversHierarchy"));
            }
            return list2;
        }

        @NotNull
        public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getFunctions"));
            }
            Set<FunctionDescriptor> set = Collections.singleton(ErrorUtils.createErrorFunction(this));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getFunctions"));
            }
            return set;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            ModuleDescriptor moduleDescriptor = ERROR_MODULE;
            if (moduleDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getContainingDeclaration"));
            }
            return moduleDescriptor;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
            if (labelName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getDeclarationsByLabel"));
            }
            List<DeclarationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getDeclarationsByLabel"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            List<DeclarationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getAllDescriptors"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            List<DeclarationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "getOwnDeclaredDescriptors"));
            }
            return list2;
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/types/ErrorUtils$ErrorScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

