/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeSelectorUtil;
import org.jetbrains.jet.utils.Printer;

public class ChainedScope
implements JetScope {
    private final DeclarationDescriptor containingDeclaration;
    private final String debugName;
    private final JetScope[] scopeChain;
    private Collection<DeclarationDescriptor> allDescriptors;
    private List<ReceiverParameterDescriptor> implicitReceiverHierarchy;

    public ChainedScope(DeclarationDescriptor containingDeclaration, String debugName, JetScope ... scopes) {
        this.containingDeclaration = containingDeclaration;
        this.scopeChain = (JetScope[])scopes.clone();
        this.debugName = debugName;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getClassifier"));
        }
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @Override
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getPackage"));
        }
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.PACKAGE_SCOPE_SELECTOR);
    }

    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getProperties"));
        }
        Set<VariableDescriptor> set = JetScopeSelectorUtil.getFromAllScopes(this.scopeChain, name, JetScopeSelectorUtil.NAMED_PROPERTIES_SCOPE_SELECTOR);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getProperties"));
        }
        return set;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getLocalVariable"));
        }
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.VARIABLE_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getFunctions"));
        }
        Set<FunctionDescriptor> set = JetScopeSelectorUtil.getFromAllScopes(this.scopeChain, name, JetScopeSelectorUtil.NAMED_FUNCTION_SCOPE_SELECTOR);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getFunctions"));
        }
        return set;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        if (this.implicitReceiverHierarchy == null) {
            this.implicitReceiverHierarchy = Lists.newArrayList();
            for (JetScope jetScope : this.scopeChain) {
                this.implicitReceiverHierarchy.addAll(jetScope.getImplicitReceiversHierarchy());
            }
        }
        List<ReceiverParameterDescriptor> list2 = this.implicitReceiverHierarchy;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getImplicitReceiversHierarchy"));
        }
        return list2;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getDeclarationsByLabel"));
        }
        for (JetScope jetScope : this.scopeChain) {
            Collection<DeclarationDescriptor> declarationsByLabel = jetScope.getDeclarationsByLabel(labelName);
            if (declarationsByLabel.isEmpty()) continue;
            Collection<DeclarationDescriptor> collection = declarationsByLabel;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getDeclarationsByLabel"));
            }
            return collection;
        }
        List<DeclarationDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getDeclarationsByLabel"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            for (JetScope scope : this.scopeChain) {
                this.allDescriptors.addAll(scope.getAllDescriptors());
            }
        }
        Collection<DeclarationDescriptor> collection = this.allDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/ChainedScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), ": ", this.debugName, " {");
        p.pushIndent();
        for (JetScope scope : this.scopeChain) {
            scope.printScopeStructure(p);
        }
        p.popIndent();
        p.println("}");
    }
}

