/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.Name;

public class SpecialNames {
    public static final Name NO_NAME_PROVIDED = Name.special("<no name provided>");
    public static final Name ROOT_PACKAGE = Name.special("<root package>");

    private SpecialNames() {
    }

    @NotNull
    public static Name getClassObjectName(@NotNull Name className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/name/SpecialNames", "getClassObjectName"));
        }
        Name name = Name.special("<class-object-for-" + className.asString() + ">");
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/SpecialNames", "getClassObjectName"));
        }
        return name;
    }

    public static boolean isClassObjectName(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/name/SpecialNames", "isClassObjectName"));
        }
        return name.isSpecial() && name.asString().startsWith("<class-object-for-");
    }
}

