/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.storage.ExceptionTracker;
import org.jetbrains.jet.storage.LazyResolveStorageManager;
import org.jetbrains.jet.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;

public class ResolveSession
implements KotlinCodeAnalyzer {
    private static final Function<FqName, Name> NO_ALIASES = new Function<FqName, Name>(){

        @Override
        public Name fun(FqName name) {
            return null;
        }
    };
    private final LazyResolveStorageManager storageManager;
    private final ExceptionTracker exceptionTracker;
    private final ModuleDescriptor module;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final Function<FqName, Name> classifierAliases;
    private final MemoizedFunctionToNullable<FqName, LazyPackageDescriptor> packages;
    private final PackageFragmentProvider packageFragmentProvider;
    private ScopeProvider scopeProvider;
    private JetImportsFactory jetImportFactory;
    private AnnotationResolver annotationResolve;
    private DescriptorResolver descriptorResolver;
    private TypeResolver typeResolver;
    private QualifiedExpressionResolver qualifiedExpressionResolver;

    public void setJetImportFactory(JetImportsFactory jetImportFactory) {
        this.jetImportFactory = jetImportFactory;
    }

    public void setAnnotationResolve(AnnotationResolver annotationResolve) {
        this.annotationResolve = annotationResolve;
    }

    public void setDescriptorResolver(DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setQualifiedExpressionResolver(QualifiedExpressionResolver qualifiedExpressionResolver) {
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull GlobalContextImpl globalContext, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull BindingTrace delegationTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.storageManager = lockBasedLazyResolveStorageManager;
        this.exceptionTracker = globalContext.getExceptionTracker();
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
        this.module = rootDescriptor;
        this.classifierAliases = NO_ALIASES;
        this.packages = this.storageManager.createMemoizedFunctionWithNullableValues(new MemoizedFunctionToNullable<FqName, LazyPackageDescriptor>(){

            @Override
            @Nullable
            public LazyPackageDescriptor invoke(FqName fqName) {
                return ResolveSession.this.createPackage(fqName);
            }
        });
        this.declarationProviderFactory = declarationProviderFactory;
        this.packageFragmentProvider = new PackageFragmentProvider(){

            @Override
            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
                if (fqName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "getPackageFragments"));
                }
                List<PackageFragmentDescriptor> list2 = ContainerUtil.createMaybeSingletonList(ResolveSession.this.getPackageFragment(fqName));
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "getPackageFragments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName) {
                if (fqName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "getSubPackagesOf"));
                }
                LazyPackageDescriptor packageDescriptor = ResolveSession.this.getPackageFragment(fqName);
                if (packageDescriptor == null) {
                    List<FqName> list2 = Collections.emptyList();
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "getSubPackagesOf"));
                    }
                    return list2;
                }
                Collection<FqName> collection = packageDescriptor.getDeclarationProvider().getAllDeclaredPackages();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "getSubPackagesOf"));
                }
                return collection;
            }
        };
        rootDescriptor.addFragmentProvider(DependencyKind.SOURCES, this.packageFragmentProvider);
    }

    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        PackageFragmentProvider packageFragmentProvider = this.packageFragmentProvider;
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getPackageFragmentProvider"));
        }
        return packageFragmentProvider;
    }

    @Nullable
    public LazyPackageDescriptor getPackageFragment(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getPackageFragment"));
        }
        return (LazyPackageDescriptor)this.packages.invoke(fqName);
    }

    @Nullable
    private LazyPackageDescriptor createPackage(FqName fqName) {
        if (!fqName.isRoot() && this.getPackageFragment(fqName.parent()) == null) {
            return null;
        }
        PackageMemberDeclarationProvider provider = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName);
        if (provider == null) {
            return null;
        }
        return new LazyPackageDescriptor(this.module, fqName, this, provider);
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getModuleDescriptor"));
        }
        return moduleDescriptor;
    }

    @NotNull
    public LazyResolveStorageManager getStorageManager() {
        LazyResolveStorageManager lazyResolveStorageManager = this.storageManager;
        if (lazyResolveStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getStorageManager"));
        }
        return lazyResolveStorageManager;
    }

    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.exceptionTracker;
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        if (classOrObject.getParent() instanceof JetClassObject) {
            LazyClassDescriptor lazyClassDescriptor = this.getClassObjectDescriptor((JetClassObject)classOrObject.getParent());
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
            }
            return lazyClassDescriptor;
        }
        JetScope resolutionScope = this.getScopeProvider().getResolutionScopeForDeclaration(classOrObject);
        Name name = ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName());
        ClassifierDescriptor scopeDescriptor = resolutionScope.getClassifier(name);
        DeclarationDescriptor descriptor = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Could not find a classifier for %s.\nFound descriptor: %s (%s).\n", JetPsiUtil.getElementTextWithContext(classOrObject), scopeDescriptor != null ? DescriptorRenderer.DEBUG_TEXT.render(scopeDescriptor) : "null", scopeDescriptor != null ? scopeDescriptor.getContainingDeclaration().getClass() : null));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    LazyClassDescriptor getClassObjectDescriptor(@NotNull JetClassObject classObject) {
        LazyClassDescriptor parentClassDescriptor;
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassObjectDescriptor"));
        }
        JetClass aClass = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetClass.class);
        if (aClass != null) {
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(aClass);
        } else {
            JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetObjectDeclaration.class);
            assert (objectDeclaration != null) : String.format("Class object %s can be in class or object in file %s", classObject, classObject.getContainingFile().getText());
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(objectDeclaration);
        }
        parentClassDescriptor.getClassObjectDescriptor();
        DeclarationDescriptor declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObject.getObjectDeclaration());
        if (declaration == null) {
            final JetClassLikeInfo classObjectInfo = parentClassDescriptor.getClassObjectInfo(classObject);
            assert (classObjectInfo != null) : String.format("Failed to find class object info for existent class object declaration: %s", JetPsiUtil.getElementTextWithContext(classObject));
            final Name name = SpecialNames.getClassObjectName(parentClassDescriptor.getName());
            LazyClassDescriptor lazyClassDescriptor = this.storageManager.compute(new Function0<LazyClassDescriptor>(){

                @Override
                public LazyClassDescriptor invoke() {
                    return new LazyClassDescriptor(ResolveSession.this, parentClassDescriptor, name, classObjectInfo);
                }
            });
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassObjectDescriptor"));
            }
            return lazyClassDescriptor;
        }
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)declaration;
        if (lazyClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassObjectDescriptor"));
        }
        return lazyClassDescriptor;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        DeclarationProviderFactory declarationProviderFactory = this.declarationProviderFactory;
        if (declarationProviderFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getDeclarationProviderFactory"));
        }
        return declarationProviderFactory;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(JetDeclaration declaration) {
        DeclarationDescriptor result = declaration.accept(new JetVisitor<DeclarationDescriptor, Void>(){

            @Override
            public DeclarationDescriptor visitClass(@NotNull JetClass klass, Void data2) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitClass"));
                }
                return ResolveSession.this.getClassDescriptor(klass);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitObjectDeclaration"));
                }
                PsiElement parent = declaration.getParent();
                if (parent instanceof JetClassObject) {
                    JetClassObject jetClassObject = (JetClassObject)parent;
                    return ResolveSession.this.resolveToDescriptor(jetClassObject);
                }
                return ResolveSession.this.getClassDescriptor(declaration);
            }

            @Override
            public DeclarationDescriptor visitClassObject(@NotNull JetClassObject classObject, Void data2) {
                if (classObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitClassObject"));
                }
                return ResolveSession.this.getClassObjectDescriptor(classObject);
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull JetTypeParameter parameter, Void data2) {
                List<TypeParameterDescriptor> typeParameters;
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitTypeParameter"));
                }
                JetTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, JetTypeParameterListOwner.class);
                DeclarationDescriptor ownerDescriptor = ResolveSession.this.resolveToDescriptor(ownerElement);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = ResolveSessionUtils.safeNameForLazyResolve(parameter.getNameAsName());
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull JetNamedFunction function, Void data2) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitNamedFunction"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getScopeProvider().getResolutionScopeForDeclaration(function);
                scopeForDeclaration.getFunctions(ResolveSessionUtils.safeNameForLazyResolve(function));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull JetParameter parameter, Void data2) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitParameter"));
                }
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof JetClass) {
                    JetClass jetClass = (JetClass)grandFather;
                    ClassDescriptor classDescriptor = ResolveSession.this.getClassDescriptor(jetClass);
                    if (parameter.getValOrVarNode() != null) {
                        classDescriptor.getDefaultType().getMemberScope().getProperties(ResolveSessionUtils.safeNameForLazyResolve(parameter));
                        return ResolveSession.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return ResolveSession.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull JetProperty property2, Void data2) {
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitProperty"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getScopeProvider().getResolutionScopeForDeclaration(property2);
                scopeForDeclaration.getProperties(ResolveSessionUtils.safeNameForLazyResolve(property2));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            }

            @Override
            public DeclarationDescriptor visitJetElement(@NotNull JetElement element, Void data2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$5", "visitJetElement"));
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + JetPsiUtil.getElementTextWithContext(element));
            }
        }, null);
        if (result == null) {
            throw new IllegalStateException("No descriptor resolved for " + declaration + " " + declaration.getText());
        }
        DeclarationDescriptor declarationDescriptor = result;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    public Name resolveClassifierAlias(@NotNull FqName packageName, @NotNull Name alias) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        Name actualName = this.classifierAliases.fun(packageName.child(alias));
        if (actualName == null) {
            Name name = alias;
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
            }
            return name;
        }
        Name name = actualName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        return name;
    }

    @NotNull
    private List<LazyPackageDescriptor> getAllPackages() {
        LazyPackageDescriptor rootPackage = this.getPackageFragment(FqName.ROOT);
        assert (rootPackage != null) : "Root package must be initialized";
        List<LazyPackageDescriptor> list2 = this.collectAllPackages(Lists.<LazyPackageDescriptor>newArrayList(), rootPackage);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getAllPackages"));
        }
        return list2;
    }

    @NotNull
    private List<LazyPackageDescriptor> collectAllPackages(@NotNull List<LazyPackageDescriptor> result, @NotNull LazyPackageDescriptor current) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        result.add(current);
        for (FqName subPackage : this.packageFragmentProvider.getSubPackagesOf(current.getFqName())) {
            LazyPackageDescriptor fragment = this.getPackageFragment(subPackage);
            assert (fragment != null) : "Couldn't find fragment for " + subPackage;
            this.collectAllPackages(result, fragment);
        }
        List<LazyPackageDescriptor> list2 = result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        return list2;
    }

    @Override
    public void forceResolveAll() {
        for (LazyPackageDescriptor lazyPackage : this.getAllPackages()) {
            ForceResolveUtil.forceResolveAllContents(lazyPackage);
        }
    }

    @NotNull
    public ScopeProvider getScopeProvider() {
        ScopeProvider scopeProvider = this.scopeProvider;
        if (scopeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getScopeProvider"));
        }
        return scopeProvider;
    }

    @NotNull
    public JetImportsFactory getJetImportsFactory() {
        JetImportsFactory jetImportsFactory = this.jetImportFactory;
        if (jetImportsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getJetImportsFactory"));
        }
        return jetImportsFactory;
    }

    @NotNull
    public AnnotationResolver getAnnotationResolver() {
        AnnotationResolver annotationResolver = this.annotationResolve;
        if (annotationResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getAnnotationResolver"));
        }
        return annotationResolver;
    }

    @NotNull
    public DescriptorResolver getDescriptorResolver() {
        DescriptorResolver descriptorResolver = this.descriptorResolver;
        if (descriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getDescriptorResolver"));
        }
        return descriptorResolver;
    }

    @NotNull
    public TypeResolver getTypeResolver() {
        TypeResolver typeResolver = this.typeResolver;
        if (typeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTypeResolver"));
        }
        return typeResolver;
    }

    @NotNull
    public QualifiedExpressionResolver getQualifiedExpressionResolver() {
        QualifiedExpressionResolver qualifiedExpressionResolver = this.qualifiedExpressionResolver;
        if (qualifiedExpressionResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getQualifiedExpressionResolver"));
        }
        return qualifiedExpressionResolver;
    }
}

