/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.PossiblyBareType;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TypeResolutionContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class TypeResolver {
    private AnnotationResolver annotationResolver;
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    private ModuleDescriptor moduleDescriptor;

    public void setAnnotationResolver(AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setQualifiedExpressionResolver(QualifiedExpressionResolver qualifiedExpressionResolver) {
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/TypeResolver", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    @NotNull
    public JetType resolveType(@NotNull JetScope scope, @NotNull JetTypeReference typeReference, BindingTrace trace, boolean checkBounds) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        JetType jetType = this.resolveType(new TypeResolutionContext(scope, trace, checkBounds, false), typeReference);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        return jetType;
    }

    @NotNull
    public JetType resolveType(@NotNull TypeResolutionContext c, @NotNull JetTypeReference typeReference) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        assert (!c.allowBareTypes) : "Use resolvePossiblyBareType() when bare types are allowed";
        JetType jetType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveType"));
        }
        return jetType;
    }

    @NotNull
    public PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull JetTypeReference typeReference) {
        JetTypeElement typeElement;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolvePossiblyBareType"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolvePossiblyBareType"));
        }
        JetType cachedType = c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            if (possiblyBareType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolvePossiblyBareType"));
            }
            return possiblyBareType;
        }
        Annotations annotations = this.annotationResolver.getResolvedAnnotations(typeReference.getAnnotations(), c.trace);
        PossiblyBareType type = this.resolveTypeElement(c, annotations, typeElement = typeReference.getTypeElement());
        if (!type.isBare()) {
            c.trace.record(BindingContext.TYPE, typeReference, type.getActualType());
        }
        c.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, typeReference, c.scope);
        PossiblyBareType possiblyBareType = type;
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolvePossiblyBareType"));
        }
        return possiblyBareType;
    }

    @NotNull
    private PossiblyBareType resolveTypeElement(final TypeResolutionContext c, final Annotations annotations, JetTypeElement typeElement) {
        final PossiblyBareType[] result = new PossiblyBareType[1];
        if (typeElement != null) {
            typeElement.accept(new JetVisitorVoid(){

                @Override
                public void visitUserType(@NotNull JetUserType type) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/TypeResolver$1", "visitUserType"));
                    }
                    JetSimpleNameExpression referenceExpression = type.getReferenceExpression();
                    String referencedName = type.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    ClassifierDescriptor classifierDescriptor = TypeResolver.this.resolveClass(c.scope, type, c.trace);
                    if (classifierDescriptor == null) {
                        TypeResolver.this.resolveTypeProjections(c, ErrorUtils.createErrorType("No type").getConstructor(), type.getTypeArguments());
                        return;
                    }
                    c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor);
                    if (classifierDescriptor instanceof TypeParameterDescriptor) {
                        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
                        JetScope scopeForTypeParameter = TypeResolver.this.getScopeForTypeParameter(c, typeParameterDescriptor);
                        result[0] = scopeForTypeParameter instanceof ErrorUtils.ErrorScope ? PossiblyBareType.type(ErrorUtils.createErrorType("?")) : PossiblyBareType.type(new JetTypeImpl(annotations, typeParameterDescriptor.getTypeConstructor(), TypeUtils.hasNullableLowerBound(typeParameterDescriptor), Collections.emptyList(), scopeForTypeParameter));
                        TypeResolver.this.resolveTypeProjections(c, ErrorUtils.createErrorType("No type").getConstructor(), type.getTypeArguments());
                        DeclarationDescriptor containing = typeParameterDescriptor.getContainingDeclaration();
                        if (containing instanceof ClassDescriptor) {
                            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, referenceExpression, (ClassDescriptor)containing);
                        }
                    } else if (classifierDescriptor instanceof ClassDescriptor) {
                        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                        TypeConstructor typeConstructor = classifierDescriptor.getTypeConstructor();
                        List arguments2 = TypeResolver.this.resolveTypeProjections(c, typeConstructor, type.getTypeArguments());
                        List<TypeParameterDescriptor> parameters = typeConstructor.getParameters();
                        int expectedArgumentCount = parameters.size();
                        int actualArgumentCount = arguments2.size();
                        if (ErrorUtils.isError(classDescriptor)) {
                            result[0] = PossiblyBareType.type(ErrorUtils.createErrorType("[Error type: " + typeConstructor + "]"));
                        } else if (actualArgumentCount != expectedArgumentCount) {
                            if (actualArgumentCount == 0) {
                                if (c.allowBareTypes) {
                                    result[0] = PossiblyBareType.bare(typeConstructor, false);
                                    return;
                                }
                                c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(type, expectedArgumentCount));
                            } else {
                                c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(type.getTypeArgumentList(), expectedArgumentCount));
                            }
                        } else {
                            JetTypeImpl resultingType = new JetTypeImpl(annotations, typeConstructor, false, arguments2, classDescriptor.getMemberScope(arguments2));
                            result[0] = PossiblyBareType.type(resultingType);
                            if (c.checkBounds) {
                                TypeSubstitutor substitutor = TypeSubstitutor.create(resultingType);
                                int parametersSize = parameters.size();
                                for (int i = 0; i < parametersSize; ++i) {
                                    TypeParameterDescriptor parameter = parameters.get(i);
                                    JetType argument = ((TypeProjection)arguments2.get(i)).getType();
                                    JetTypeReference typeReference = type.getTypeArguments().get(i).getTypeReference();
                                    if (typeReference == null) continue;
                                    DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor, c.trace);
                                }
                            }
                        }
                    }
                }

                @Override
                public void visitNullableType(@NotNull JetNullableType nullableType) {
                    if (nullableType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/jet/lang/resolve/TypeResolver$1", "visitNullableType"));
                    }
                    PossiblyBareType baseType = TypeResolver.this.resolveTypeElement(c, annotations, nullableType.getInnerType());
                    if (baseType.isNullable()) {
                        c.trace.report(Errors.REDUNDANT_NULLABLE.on(nullableType));
                    } else if (!baseType.isBare() && TypeUtils.hasNullableSuperType(baseType.getActualType())) {
                        c.trace.report(Errors.BASE_WITH_NULLABLE_UPPER_BOUND.on(nullableType, baseType.getActualType()));
                    }
                    result[0] = baseType.makeNullable();
                }

                @Override
                public void visitFunctionType(@NotNull JetFunctionType type) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/TypeResolver$1", "visitFunctionType"));
                    }
                    JetTypeReference receiverTypeRef = type.getReceiverTypeRef();
                    JetType receiverType = receiverTypeRef == null ? null : TypeResolver.this.resolveType(c.noBareTypes(), receiverTypeRef);
                    ArrayList<JetType> parameterTypes = new ArrayList<JetType>();
                    for (JetParameter parameter : type.getParameters()) {
                        parameterTypes.add(TypeResolver.this.resolveType(c.noBareTypes(), parameter.getTypeReference()));
                    }
                    JetTypeReference returnTypeRef = type.getReturnTypeRef();
                    JetType returnType2 = returnTypeRef != null ? TypeResolver.this.resolveType(c.noBareTypes(), returnTypeRef) : KotlinBuiltIns.getInstance().getUnitType();
                    result[0] = PossiblyBareType.type(KotlinBuiltIns.getInstance().getFunctionType(annotations, receiverType, parameterTypes, returnType2));
                }

                @Override
                public void visitJetElement(@NotNull JetElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/TypeResolver$1", "visitJetElement"));
                    }
                    c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }
            });
        }
        if (result[0] == null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorType(typeElement == null ? "No type element" : typeElement.getText()));
            if (possiblyBareType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveTypeElement"));
            }
            return possiblyBareType;
        }
        PossiblyBareType possiblyBareType = result[0];
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveTypeElement"));
        }
        return possiblyBareType;
    }

    private JetScope getScopeForTypeParameter(TypeResolutionContext c, final TypeParameterDescriptor typeParameterDescriptor) {
        if (c.checkBounds) {
            return typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
        }
        return new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            }
        }));
    }

    @NotNull
    private List<TypeProjection> resolveTypeProjections(TypeResolutionContext c, TypeConstructor constructor, List<JetTypeProjection> argumentElements) {
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>();
        int argumentElementsSize = argumentElements.size();
        for (int i = 0; i < argumentElementsSize; ++i) {
            TypeParameterDescriptor parameterDescriptor;
            JetTypeProjection argumentElement = argumentElements.get(i);
            JetProjectionKind projectionKind = argumentElement.getProjectionKind();
            if (projectionKind == JetProjectionKind.STAR) {
                List<TypeParameterDescriptor> parameters = constructor.getParameters();
                if (parameters.size() > i) {
                    parameterDescriptor = parameters.get(i);
                    arguments2.add(SubstitutionUtils.makeStarProjection(parameterDescriptor));
                    continue;
                }
                arguments2.add(new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*")));
                continue;
            }
            JetType type = this.resolveType(c.noBareTypes(), argumentElement.getTypeReference());
            Variance kind = TypeResolver.resolveProjectionKind(projectionKind);
            if (constructor.getParameters().size() > i) {
                parameterDescriptor = constructor.getParameters().get(i);
                if (kind != Variance.INVARIANT && parameterDescriptor.getVariance() != Variance.INVARIANT) {
                    if (kind == parameterDescriptor.getVariance()) {
                        c.trace.report(Errors.REDUNDANT_PROJECTION.on(argumentElement, constructor.getDeclarationDescriptor()));
                    } else {
                        c.trace.report(Errors.CONFLICTING_PROJECTION.on(argumentElement, constructor.getDeclarationDescriptor()));
                    }
                }
            }
            arguments2.add(new TypeProjectionImpl(kind, type));
        }
        ArrayList<TypeProjection> arrayList = arguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveTypeProjections"));
        }
        return arrayList;
    }

    @NotNull
    public static Variance resolveProjectionKind(@NotNull JetProjectionKind projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveProjectionKind"));
        }
        Variance kind = null;
        switch (projectionKind) {
            case IN: {
                kind = Variance.IN_VARIANCE;
                break;
            }
            case OUT: {
                kind = Variance.OUT_VARIANCE;
                break;
            }
            case NONE: {
                kind = Variance.INVARIANT;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
            }
        }
        Variance variance = kind;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeResolver", "resolveProjectionKind"));
        }
        return variance;
    }

    @Nullable
    public ClassifierDescriptor resolveClass(JetScope scope, JetUserType userType, BindingTrace trace) {
        Collection<? extends DeclarationDescriptor> descriptors = this.qualifiedExpressionResolver.lookupDescriptorsForUserType(userType, scope, trace);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            if (!(declarationDescriptor instanceof ClassifierDescriptor)) continue;
            ImportsResolver.reportPlatformClassMappedToKotlin(this.moduleDescriptor, trace, userType, declarationDescriptor);
            return (ClassifierDescriptor)declarationDescriptor;
        }
        return null;
    }
}

