/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SynthesizedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.Slices;

public class BindingContextUtils {
    private static final Slices.KeyNormalizer<DeclarationDescriptor> DECLARATION_DESCRIPTOR_NORMALIZER = new Slices.KeyNormalizer<DeclarationDescriptor>(){

        @Override
        public DeclarationDescriptor normalize(DeclarationDescriptor declarationDescriptor) {
            CallableMemberDescriptor callable2;
            if (declarationDescriptor instanceof CallableMemberDescriptor && (callable2 = (CallableMemberDescriptor)declarationDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                throw new IllegalStateException("non-declaration descriptors should be filtered out earlier: " + callable2);
            }
            return declarationDescriptor.getOriginal();
        }
    };
    static final ReadOnlySlice<DeclarationDescriptor, PsiElement> DESCRIPTOR_TO_DECLARATION = Slices.sliceBuilder().setKeyNormalizer(DECLARATION_DESCRIPTOR_NORMALIZER).setDebugName("DESCRIPTOR_TO_DECLARATION").build();

    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull BindingContext bindingContext, @Nullable JetElement element, boolean onlyReference) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "extractVariableDescriptorIfAny"));
        }
        DeclarationDescriptor descriptor = null;
        if (!onlyReference && (element instanceof JetVariableDeclaration || element instanceof JetParameter)) {
            descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        } else if (element instanceof JetSimpleNameExpression) {
            descriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, (JetSimpleNameExpression)element);
        } else if (element instanceof JetQualifiedExpression) {
            descriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, ((JetQualifiedExpression)element).getSelectorExpression(), onlyReference);
        }
        if (descriptor instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor;
        }
        return null;
    }

    @Nullable
    public static JetFile getContainingFile(@NotNull BindingContext context, @NotNull DeclarationDescriptor declarationDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getContainingFile"));
        }
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getContainingFile"));
        }
        DeclarationDescriptor descriptor = DescriptorUtils.findTopLevelParent(declarationDescriptor);
        if (descriptor == null) {
            return null;
        }
        PsiElement declaration = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (declaration == null) {
            return null;
        }
        PsiFile containingFile = declaration.getContainingFile();
        if (!(containingFile instanceof JetFile)) {
            return null;
        }
        return (JetFile)containingFile;
    }

    @Nullable
    private static PsiElement doGetDescriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "doGetDescriptorToDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "doGetDescriptorToDeclaration"));
        }
        return context.get(DESCRIPTOR_TO_DECLARATION, descriptor);
    }

    @Nullable
    public static PsiElement descriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclaration"));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            return BindingContextUtils.callableDescriptorToDeclaration(context, (CallableMemberDescriptor)descriptor);
        }
        if (descriptor instanceof ClassDescriptor) {
            return BindingContextUtils.classDescriptorToDeclaration(context, (ClassDescriptor)descriptor);
        }
        return BindingContextUtils.doGetDescriptorToDeclaration(context, descriptor);
    }

    @NotNull
    public static List<PsiElement> descriptorToDeclarations(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclarations"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclarations"));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            List<PsiElement> list2 = BindingContextUtils.callableDescriptorToDeclarations(context, (CallableMemberDescriptor)descriptor);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclarations"));
            }
            return list2;
        }
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (psiElement != null) {
            ArrayList<PsiElement> arrayList = Lists.newArrayList(psiElement);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclarations"));
            }
            return arrayList;
        }
        ArrayList<PsiElement> arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "descriptorToDeclarations"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement callableDescriptorToDeclaration(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclaration"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclaration"));
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            CallableMemberDescriptor original = callable2.getOriginal();
            if (original instanceof SynthesizedCallableMemberDescriptor) {
                Object base = ((SynthesizedCallableMemberDescriptor)original).getBaseForSynthesized();
                return BindingContextUtils.descriptorToDeclaration(context, base);
            }
            return null;
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return BindingContextUtils.doGetDescriptorToDeclaration(context, callable2.getOriginal());
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable2.getOverriddenDescriptors();
        if (overriddenDescriptors.size() != 1) {
            throw new IllegalStateException("Cannot find declaration: fake descriptor " + callable2 + " has more than one overridden descriptor:\n" + StringUtil.join(overriddenDescriptors, ",\n"));
        }
        return BindingContextUtils.callableDescriptorToDeclaration(context, overriddenDescriptors.iterator().next());
    }

    @NotNull
    public static List<PsiElement> callableDescriptorToDeclarations(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            CallableMemberDescriptor original = callable2.getOriginal();
            if (original instanceof SynthesizedCallableMemberDescriptor) {
                Object base = ((SynthesizedCallableMemberDescriptor)original).getBaseForSynthesized();
                List<PsiElement> list2 = BindingContextUtils.descriptorToDeclarations(context, base);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
                }
                return list2;
            }
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
            }
            return list3;
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            PsiElement psiElement = BindingContextUtils.doGetDescriptorToDeclaration(context, callable2);
            ArrayList<PsiElement> arrayList = psiElement != null ? Lists.newArrayList(psiElement) : Lists.newArrayList();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
            }
            return arrayList;
        }
        ArrayList<PsiElement> r = new ArrayList<PsiElement>();
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable2.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            r.addAll(BindingContextUtils.callableDescriptorToDeclarations(context, callableMemberDescriptor));
        }
        ArrayList<PsiElement> arrayList = r;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "callableDescriptorToDeclarations"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement classDescriptorToDeclaration(@NotNull BindingContext context, @NotNull ClassDescriptor clazz) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "classDescriptorToDeclaration"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "classDescriptorToDeclaration"));
        }
        return BindingContextUtils.doGetDescriptorToDeclaration(context, clazz);
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            throw new IllegalArgumentException("function of kind " + (Object)((Object)function.getKind()) + " cannot have declaration");
        }
        trace.record(BindingContext.FUNCTION, psiElement, function);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        V v = BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        if (messageIfNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageIfNull", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        V value = bindingContext.get(slice, key);
        if (value == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull JetElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        JetNamedDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        if (declaration instanceof JetFunctionLiteral) {
            DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(context, declaration);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingDescriptor"));
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        return declarationDescriptor;
    }

    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull JetElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        JetFunction function = PsiTreeUtil.getParentOfType((PsiElement)element, JetFunction.class);
        return (FunctionDescriptor)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull JetSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (declarationsByLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsByLabel", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : declarationsByLabel) {
            PsiElement element = BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), descriptor);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static JetType updateRecordedType(@Nullable JetType type, @NotNull JetExpression expression, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (type == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type = TypeUtils.makeNullable(type);
        }
        trace.record(BindingContext.EXPRESSION_TYPE, expression, type);
        return type;
    }

    @Nullable
    public static JetTypeInfo getRecordedTypeInfo(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (!context.get(BindingContext.PROCESSED, expression).booleanValue()) {
            return null;
        }
        DataFlowInfo dataFlowInfo = context.get(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression);
        if (dataFlowInfo == null) {
            dataFlowInfo = DataFlowInfo.EMPTY;
        }
        JetType type = context.get(BindingContext.EXPRESSION_TYPE, expression);
        return JetTypeInfo.create(type, dataFlowInfo);
    }

    public static boolean isExpressionWithValidReference(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (expression instanceof JetCallExpression) {
            return BindingContextUtils.isCallExpressionWithValidReference(expression, context);
        }
        return expression instanceof JetReferenceExpression;
    }

    public static boolean isCallExpressionWithValidReference(@NotNull JetExpression expression, @NotNull BindingContext context) {
        JetExpression calleeExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "isCallExpressionWithValidReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "isCallExpressionWithValidReference"));
        }
        return expression instanceof JetCallExpression && (resolvedCall = context.get(BindingContext.RESOLVED_CALL, calleeExpression = ((JetCallExpression)expression).getCalleeExpression())) instanceof VariableAsFunctionResolvedCall;
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getDirectlyOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        HashSet<CallableMemberDescriptor> result = Sets.newHashSet();
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = descriptor.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result.add(callableMemberDescriptor);
                continue;
            }
            if (kind == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || kind == CallableMemberDescriptor.Kind.DELEGATION) {
                result.addAll(BindingContextUtils.getDirectlyOverriddenDeclarations(callableMemberDescriptor));
                continue;
            }
            if (kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
        }
        Set<CallableMemberDescriptor> set = OverridingUtil.filterOutOverridden(result);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    public static Set<FunctionDescriptor> getDirectlyOverriddenDeclarations(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        Set<CallableMemberDescriptor> set = BindingContextUtils.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    public static Set<PropertyDescriptor> getDirectlyOverriddenDeclarations(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        Set<CallableMemberDescriptor> set = BindingContextUtils.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    public static <T extends CallableMemberDescriptor> Set<T> getAllOverriddenDeclarations(@NotNull T memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getAllOverriddenDeclarations"));
        }
        HashSet<CallableMemberDescriptor> result = Sets.newHashSet();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result.add(callableMemberDescriptor);
            } else if (kind != CallableMemberDescriptor.Kind.DELEGATION && kind != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
            result.addAll(BindingContextUtils.getAllOverriddenDeclarations(callableMemberDescriptor));
        }
        HashSet<CallableMemberDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BindingContextUtils", "getAllOverriddenDeclarations"));
        }
        return hashSet;
    }
}

