/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetInitializerList;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetClassElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;

public class JetEnumEntry
extends JetClass {
    public JetEnumEntry(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetEnumEntry", "<init>"));
        }
        super(node);
    }

    public JetEnumEntry(@NotNull PsiJetClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetEnumEntry", "<init>"));
        }
        super(stub);
    }

    @Override
    public String getName() {
        PsiJetClassStub classStub = (PsiJetClassStub)this.getStub();
        if (classStub != null) {
            return classStub.getName();
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? "<Anonymous>" : nameAsDeclaration.getName();
    }

    @Override
    public PsiElement getNameIdentifier() {
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getNameIdentifier();
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        JetClassElementType jetClassElementType = JetStubElementTypes.ENUM_ENTRY;
        if (jetClassElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetEnumEntry", "getElementType"));
        }
        return jetClassElementType;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetEnumEntry", "setName"));
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.setName(name);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetInitializerList initializerList = (JetInitializerList)this.findChildByType(JetNodeTypes.INITIALIZER_LIST);
        if (initializerList == null) {
            List<JetDelegationSpecifier> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetEnumEntry", "getDelegationSpecifiers"));
            }
            return list2;
        }
        List<JetDelegationSpecifier> list3 = initializerList.getInitializers();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetEnumEntry", "getDelegationSpecifiers"));
        }
        return list3;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetEnumEntry", "accept"));
        }
        return visitor.visitEnumEntry(this, data2);
    }
}

