/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetContainerNode;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetArrayAccessExpression
extends JetReferenceExpression {
    public JetArrayAccessExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "accept"));
        }
        return visitor.visitArrayAccessExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public JetExpression getArrayExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @NotNull
    public List<JetExpression> getIndexExpressions() {
        List<JetExpression> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this.getIndicesNode(), JetExpression.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "getIndexExpressions"));
        }
        return list2;
    }

    @NotNull
    public JetContainerNode getIndicesNode() {
        JetContainerNode indicesNode = (JetContainerNode)this.findChildByType(JetNodeTypes.INDICES);
        assert (indicesNode != null) : "Can't be null because of parser";
        JetContainerNode jetContainerNode = indicesNode;
        if (jetContainerNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "getIndicesNode"));
        }
        return jetContainerNode;
    }

    @NotNull
    public List<TextRange> getBracketRanges() {
        PsiElement lBracket = this.getIndicesNode().findChildByType(JetTokens.LBRACKET);
        PsiElement rBracket = this.getIndicesNode().findChildByType(JetTokens.RBRACKET);
        if (lBracket == null || rBracket == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "getBracketRanges"));
            }
            return list2;
        }
        ArrayList<TextRange> arrayList = Lists.newArrayList(lBracket.getTextRange(), rBracket.getTextRange());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetArrayAccessExpression", "getBracketRanges"));
        }
        return arrayList;
    }
}

