/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$1;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$2;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitCallExpression$arguments$1;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitConstantExpression$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage-ConstantExpressionEvaluator-65c28a8c;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage-OperationsMapGenerated-a6f5ab90;
import org.jetbrains.jet.lang.evaluate.EvaluatorContext;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=14, data={"d\u0018)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*AQM^1mk\u0006$XM\u0003\u0006KKR4\u0016n]5u_JT1\u0001]:j\u0015M\u0019u.\u001c9jY\u0016$\u0016.\\3D_:\u001cH/\u00198u\u0015\u001d\u0011Xm]8mm\u0016T\u0011bY8ogR\fg\u000e^:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0019a\u0014N\\5u}))AO]1dK*a!)\u001b8eS:<GK]1dK*)2-\u00198CKV\u001bX\rZ%o\u0003:tw\u000e^1uS>t'BC3yaJ,7o]5p]*i!*\u001a;FqB\u0014Xm]:j_:TqAQ8pY\u0016\fgNC\rde\u0016\fG/Z\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(\"\u0002<bYV,'\u0002D3ya\u0016\u001cG/\u001a3UsB,'BB5t!V\u0014XM\u0003\u0003kCZ\f'BB(cU\u0016\u001cGOC\fde\u0016\fG/Z(qKJ\fG/[8o\u0003J<W/\\3oi*qQ\r\u001f9sKN\u001c\u0018n\u001c8UsB,'bD2p[BLG.\u001a+j[\u0016$\u0016\u0010]3\u000b\u001f\r{W\u000e]5mKRKW.\u001a+za\u0016T\u0011c\u00149fe\u0006$\u0018n\u001c8Be\u001e,X.\u001a8u\u00155\u001auN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe\u0012z\u0005/\u001a:bi&|g.\u0011:hk6,g\u000e\u001e\u0006)GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]R4uN\u001d$jeN$\b+\u0019:b[\u0016$XM\u001d\u0006\tCJ<W/\\3oi*)\"+Z:pYZ,GMV1mk\u0016\f%oZ;nK:$(\"B2bY2\u001c(\"B7pI\u0016d'\"\u00039be\u0006lW\r^3s\u0015a1\u0016\r\\;f!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\u0012de\u0016\fG/Z(qKJ\fG/[8o\u0003J<W/\\3oi\u001a{'OU3dK&4XM\u001d\u0006\re\u0016\u001cx\u000e\u001c<fI\u000e\u000bG\u000e\u001c\u0006\r%\u0016\u001cx\u000e\u001c<fI\u000e\u000bG\u000e\u001c\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'O\u0003\ffm\u0006dW/\u0019;f\u0005&t\u0017M]=B]\u0012\u001c\u0005.Z2l\u0015!\u0011XmY3jm\u0016\u0014(\u0002\u00028b[\u0016Taa\u0015;sS:<'BD2bY2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\rKZ\fG.^1uK\u000e\u000bG\u000e\u001c\u0006\u000fMVdG.\u0012=qe\u0016\u001c8/[8o\u0015I\u0011XmY3jm\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b+\u00154\u0018\r\\;bi\u0016,f.\u0019:z\u0003:$7\t[3dW*\u0001\u0012n\u001d#jm&\u001c\u0018n\u001c8Csj+'o\u001c\u0006\u000fSN\u0004VO]3D_:\u001cH/\u00198u\u0015A\u0011Xm]8mm\u0016\f%oZ;nK:$8O\u0003\bwC2,X-\u0011:hk6,g\u000e^:\u000b\t1K7\u000f\u001e\u0006\u000e-\u0006dW/Z!sOVlWM\u001c;\u000b\tU$\u0018\u000e\u001c\u0006\u001agR\u0014\u0018N\\4FqB\u0014Xm]:j_:,e/\u00197vCR|'OC\u001cD_:\u001cH/\u00198u\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN\u001d\u0013tiJLgnZ#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014H%\r\u0006\u001dO\u0016$8\u000b\u001e:j]\u001e,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015!9W\r\u001e+sC\u000e,'\"\u0006<jg&$()\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0014\u0015\u0016$()\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0014m&\u001c\u0018\u000e^\"bY2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0012\u0015\u0016$8)\u00197m\u000bb\u0004(/Z:tS>t'b\u0006<jg&$8i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u0015UQU\r^\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:TqB^5tSRTU\r^#mK6,g\u000e\u001e\u0006\bK2,W.\u001a8u\u0015)QU\r^#mK6,g\u000e\u001e\u0006\u001dm&\u001c\u0018\u000e\u001e)be\u0016tG\u000f[3tSj,G-\u0012=qe\u0016\u001c8/[8o\u0015iQU\r\u001e)be\u0016tG\u000f[3tSj,G-\u0012=qe\u0016\u001c8/[8o\u0015U1\u0018n]5u!J,g-\u001b=FqB\u0014Xm]:j_:T1CS3u!J,g-\u001b=FqB\u0014Xm]:j_:T\u0001D^5tSR\fV/\u00197jM&,G-\u0012=qe\u0016\u001c8/[8o\u0015YQU\r^)vC2Lg-[3e\u000bb\u0004(/Z:tS>t'\"\u0007<jg&$8+[7qY\u0016t\u0015-\\3FqB\u0014Xm]:j_:TqCS3u'&l\u0007\u000f\\3OC6,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b;YL7/\u001b;TiJLgn\u001a+f[Bd\u0017\r^3FqB\u0014Xm]:j_:T1DS3u'R\u0014\u0018N\\4UK6\u0004H.\u0019;f\u000bb\u0004(/Z:tS>t'\u0002\u0006<jg&$XK\\1ss\u0016C\bO]3tg&|gN\u0003\nKKR,f.\u0019:z\u000bb\u0004(/Z:tS>tGx\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0019\u0001c\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013AA\u0001\u0004\u0001\u0006\u0003!1Qa\u0001C\u0006\u0011\u0017a\u0001!\u0002\u0002\u0005\u0004!9Qa\u0001C\u0007\u0011\u001ba\u0001!B\u0002\u0005\t!EA\u0002A\u0003\u0003\t\u0011A\t\"B\u0002\u0005\u0007!QA\u0002A\u0003\u0004\t\u0017A)\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u0001BC\u0003\u0003\t\u0013AA!B\u0001\t\u001b\u0015\u0011AQ\u0003\u0005\u0003\u000b\t!1\u0002c\u0007\u0006\u0005\u00115\u0001RB\u0003\u0004\t\tAy\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0005\u0007\u0001\u000b\t!!\u0001#\t\u0006\u0005\u0011\u0011\u0001rD\u0003\u0003\t\u0011A)#\u0002\u0002\u0005\u001e!\u0019Ra\u0001\u0003\u0010\u0011Ia\u0001!\u0002\u0002\u0005\u0004!%Ra\u0001\u0003\u0011\u0011Qa\u0001!\u0002\u0002\u0005\u001f!\u0011RA\u0001\u0003\u0011\u0011Q)1\u0001B\b\t-1\u0001Qa\u0001\u0003\u0011\u0011[a\u0001!\u0002\u0002\u0005\u001f!1Ra\u0001C\u0006\u0011ca\u0001!\u0002\u0002\u0005\u0017!ERa\u0001C\u0006\u0011wa\u0001!B\u0002\u0005\u0007!qB\u0002A\u0003\u0003\t+Ai$\u0002\u0002\u0005,!mRA\u0001\u0003\u0003\u0011\u007f)1\u0001B\u0002\tD1\u0001QA\u0001\u0003\u0004\u0011\u0007*1\u0001B\u0002\tF1\u0001QA\u0001\u0003\u0004\u0011\u000b*1\u0001B\u0002\tH1\u0001QA\u0001\u0003\u0004\u0011\u000f*1\u0001B\u0002\tK1\u0001QA\u0001\u0003\u0004\u0011\u0015*1\u0001B\u0002\tM1\u0001QA\u0001\u0003\u0004\u0011\u0019*1\u0001B\u0002\tO1\u0001QA\u0001\u0003\u0004\u0011\u001d*1\u0001B\u0002\tQ1\u0001QA\u0001\u0003\u0004\u0011!*1\u0001B\u0002\tS1\u0001QA\u0001\u0003\u0004\u0011%*1\u0001B\u0002\tU1\u0001QA\u0001\u0003\u0004\u0011)*1\u0001B\u0002\tW1\u0001QA\u0001\u0003\u0004\u0011-\"9\u0001$\u0002\u0012\u0001e\u0001R!\u0001E\u0004\u0013%I\u0001\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\n\u0007%\u0011Q!\u0001\u0005\b9Ai3\u0003B\u0001\u0019\u0013u5A\u0001\u0001E\n\u001b\t)\u0011\u0001#\u0005Q\u0007\u0001\t#!B\u0001\t\u0013E\u001bQ\u0001B\u0005\n\u0003\u0011\u0005Q\"\u0001E\n[c\"\u0001\u0001G\u0006\u001e\u0010\u0011\u0001\u0001rC\u0007\u0004\u000b\u0005Aa\u0001$\u0001Q\u0007\u0001iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011AO\u0007\t\u0005AI\"\u0004\u0002\u0006\u0003!I\u0001kA\u0001\u001e\u000e\u0011\t\u0001\"C\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0002C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007-!1\"C\u0001\t\u00155\t\u0001rC\u0007\u0002\u00111i\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q&\f\u0003\u000219ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\t!\u000e\u0001QT\u0002\u0003\u0001\u0011;i!!B\u0001\t\u000fA\u001b\t!(\u0007\u0005\u0001!yQ\u0002C\u0003\u0002\u00113IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001!\u000e\t\u0011eA\u0003\u0002\u00115a\t!U\u0002\n\t9I\u0011\u0001c\u0007\u000e\u0003!MQ\"\u0001\u0005\r\u001b\u0005Aa\"l\u000f\u0005\u0003a\tRT\u0002\u0003\u0001\u0011Gi!!B\u0001\t A\u001b\u0001!(\u0004\u0005\u0001!\u001dRBA\u0003\u0002\u0011C\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002$\u0001R\u0007\u001d!\u0011#C\u0001\t\u001c5\t\u0001\"E\u0007\u0002\u0011Gi;\u0005B\u0001\u0019+ueA\u0001\u0001E\u0016\u001b!)\u0011\u0001\u0003\n\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011Ka\t\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u000e\u0019\u0003\t6a\u0002\u0003\u0016\u0013\u0005AY\"D\u0001\t'5\t\u00012CW%\t\u0005A*!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011#\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9AQA\u0005\u0002\u0011)i\u0011\u0001c\u0005\u000e\u0003!aQ\u0016\r\u0003\u00021]ij\u0001\u0002\u0001\t05\u0011Q!\u0001\u0005\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011Oi!!B\u0001\t\u001bA\u001b\t!(\u0004\u0005\u0001!ARBA\u0003\u0002\u0011O\u00016!AO\u0007\t\u0001A\u0011$\u0004\u0002\u0006\u0003!E\u0001ka\u0001\"\u0007\u0015\t\u0001B\u0002G\u0001#\u000eYAaF\u0005\u0002\u0011/i\u0011\u0001c\u0007\u000e\u0003!mQ\"\u0001\u0005\u0015\u001b\u0005A\u0019\"l\u001c\u0005\u0003aMRT\u0002\u0003\u0001\u0011ii!!B\u0001\t\u0012A\u001b\u0001!(\u0004\u0005\u0001!IRBA\u0003\u0002\u0011#\u00016\u0011AO\u0007\t\u0001A)$\u0004\u0002\u0006\u0003!E\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0007\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001b1\u0002b\r\n\u0003!QQ\"\u0001E\n\u001b\u0005A\u0019\"D\u0001\t\u00145\t\u0001\u0002D\u0017(\t\u0005A2$(\u0004\u0005\u0001!=RBA\u0003\u0002\u00115\u00016\u0001AO\u0007\t\u0001A\u0001$\u0004\u0002\u0006\u0003!\u001d\u0002k!\u0001\u001e\u000e\u0011\u0001\u0001\"G\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0002C\r)\u0011\u0001\u0003\u0004\r\u0002E\u001b\u0011\u0002B\u000e\n\u0003!]Q\"\u0001E\u000e\u001b\u0005AA#D\u0001\t\u00145nB!\u0001M\u001c;\u001b!\u0001\u0001\u0003\r\u000e\u0005\u0015\t\u0001r\u0005)\u0004\u0001u=A\u0001\u0001E\u0014\u001b\r)\u0011\u0001\u0003\u0004\r\u0002A\u001b\t!\t\u0002\u0006\u0003!I\u0011kA\u0004\u00058%\tA\u0011A\u0007\u0002\u0011Qi\u0011\u0001c\u0006.'\u0011\t\u0001\u0004HO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!E\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u000b\u0011a\u0012\"\u0001C\u0001\u001b\u0005A\u0019\",\u0016\u0005\u0003aeRT\u0003\u0003\u0001\u0011uia!B\u0001\t*%\u0019\u0011BA\u0003\u0002\u0011U\u00016\u0001AO\u0007\t\u0001AA\"\u0004\u0002\u0006\u0003!9\u0001k!\u0001\"\u0019\u0015\t\u0001\u0012F\u0005\n\u0013!)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t!U\u0002\b\tsI\u0011\u0001\u0003\f\u000e\u0003!1R\"\u0001\u0005\r[=!\u0011\r\u0002\r C\t)\u0011\u0001\u0003\u0004V\u0007!)1\u0001B\u0010\n\u0003!5Rb\u0001\u0003!\u0013\u0005Ai#L\b\u0005A\u0012A\u0002\"\t\u0002\u0006\u0003!=Qk\u0001\u0005\u0006\u0007\u0011A\u0011\"\u0001\u0005\t\u001b\r!\t%C\u0001\t\u00115&Ca\u0003\r\";\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001b\u0006)\u0004\u0001u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005C%\t\u0001BC\u0007\u0002\u0011_i\u0011\u0001\u0003\u0007.J\u0011Y\u0001DIO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!A\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001bq\u0001\u0002\u0012\n\u0003!QQ\"\u0001E\u0019\u001b\u0005AA\",\u0013\u0005\u0017a\u0019ST\u0002\u0003\u0001\u0011'i!!B\u0001\t3A\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007\u001d!1%C\u0001\t\u00155\t\u00012G\u0007\u0002\u00111iK\u0005B\u0006\u0019Iu5A\u0001\u0001E%\u001b\t)\u0011\u0001\u0003\u000eQ\u0007\u0001iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0007\u0019\u0003a\t!U\u0002\b\t\u0011J\u0011\u0001\u0003\u0006\u000e\u0003!UR\"\u0001\u0005\r[\u0013\"1\u0002g\u0013\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A1\u0004U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6a\u0002C&\u0013\u0005A!\"D\u0001\t85\t\u0001\u0002DW%\t-Aj%(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011q\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9AQJ\u0005\u0002\u0011)i\u0011\u0001#\u000f\u000e\u0003!aQ\u0016\n\u0003\f1\u001fjj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\u001e!\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011=\u0013\"\u0001\u0005\u000b\u001b\u0005AY$D\u0001\t\u00195&Ca\u0003M);\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001B\b)\u0004\u0001u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005R%\t\u0001BC\u0007\u0002\u0011{i\u0011\u0001\u0003\u0007.J\u0011Y\u00014KO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!y\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001bq\u0001b\u0015\n\u0003!QQ\"\u0001E \u001b\u0005AA\",\u0013\u0005\u0017aUST\u0002\u0003\u0001\u0011'i!!B\u0001\tAA\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007\u001d!)&C\u0001\t\u00155\t\u0001\u0012I\u0007\u0002\u00111)L#b\n\u0005C\u0004Az!(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001f\u00016\u0001A\u0011\u0003\u000b\u0005A)!U\u0002\u0006\t\u001fI\u0011\u0001\u0002\u0001\u000e\u0003!A\u0001"})
@suppress(names={"PARAMETER_NAME_CHANGED_ON_OVERRIDE"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<? extends Object>, JetType>
implements KObject {
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final object object$ = object.$init$b$0();

    private final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        CompileTimeConstant recordedCompileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        boolean bl = true;
        if (recordedCompileTimeConstant == null) {
            bl = false;
        }
        if (bl) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(jetVisitor, jetType);
        boolean bl2 = true;
        if (compileTimeConstant == null) {
            bl2 = false;
        }
        if (bl2) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitConstantExpression"));
        }
        String text = expression.getText();
        boolean bl = true;
        if (text != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object object3 = expression.getNode().getElementType();
        if (Intrinsics.areEqual(object3, JetNodeTypes.INTEGER_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.parseLong(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.FLOAT_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object2 = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.parseBoolean(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.CHARACTER_CONSTANT)) {
            object2 = CompileTimeConstantChecker.parseChar(expression);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.NULL)) {
            object2 = null;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        Long result = object2;
        boolean bl2 = true;
        if (result != null) {
            bl2 = false;
        }
        if (bl2 ? Intrinsics.areEqual(expression.getNode().getElementType(), JetNodeTypes.NULL) : false) {
            return NullValue.NULL;
        }
        object3 = new ConstantExpressionEvaluator$visitConstantExpression$1(text, expression);
        return ConstantExpressionEvaluator.createCompileTimeConstant$default(this, result, expectedType, !((ConstantExpressionEvaluator$visitConstantExpression$1)object3).invoke(), false, 8);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitParenthesizedExpression"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        boolean bl = true;
        if (deparenthesizedExpression == null) {
            bl = false;
        }
        if (bl ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitPrefixExpression(@JetValueParameter(name="expression") @NotNull JetPrefixExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitPrefixExpression"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        boolean bl = true;
        if (deparenthesizedExpression == null) {
            bl = false;
        }
        return (bl ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) ? this.evaluate(deparenthesizedExpression, expectedType) : (CompileTimeConstant)super.visitPrefixExpression(expression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitStringTemplateExpression"));
        }
        StringBuilder sb = new StringBuilder();
        int interupted = 0;
        int canBeUsedInAnnotation = 1;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry = jetStringTemplateEntryArray[i];
            StringValue constant = this.stringExpressionEvaluator.evaluate(entry);
            boolean bl = true;
            if (constant != null) {
                bl = false;
            }
            if (bl) {
                interupted = 1;
                break;
            }
            if (!constant.canBeUsedInAnnotations()) {
                canBeUsedInAnnotation = 0;
            }
            sb.append((String)constant.getValue());
        }
        return interupted == 0 ? this.createCompileTimeConstant(sb.toString(), expectedType, true, canBeUsedInAnnotation != 0) : (CompileTimeConstant<? extends Object>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitBinaryExpression"));
        }
        JetExpression leftExpression = expression.getLeft();
        boolean bl = true;
        if (leftExpression != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl2;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<? extends Object> leftConstant = this.evaluate(leftExpression, booleanType);
            boolean bl3 = true;
            if (leftConstant != null) {
                bl3 = false;
            }
            if (bl3) {
                return null;
            }
            JetExpression rightExpression = expression.getRight();
            boolean bl4 = true;
            if (rightExpression != null) {
                bl4 = false;
            }
            if (bl4) {
                return null;
            }
            CompileTimeConstant<? extends Object> rightConstant = this.evaluate(rightExpression, booleanType);
            boolean bl5 = true;
            if (rightConstant != null) {
                bl5 = false;
            }
            if (bl5) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            boolean bl6 = !(!(leftValue instanceof Boolean)) ? !(rightValue instanceof Boolean) : true;
            if (bl6) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                Object object2 = leftValue;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Boolean");
                }
                if (((Boolean)object2).booleanValue()) {
                    Object object3 = rightValue;
                    if (object3 == null) {
                        throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Boolean");
                    }
                    bl2 = (Boolean)object3;
                } else {
                    bl2 = false;
                }
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                Object object4 = leftValue;
                if (object4 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Boolean");
                }
                if (!((Boolean)object4).booleanValue()) {
                    Object object5 = rightValue;
                    if (object5 == null) {
                        throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Boolean");
                    }
                    bl2 = (Boolean)object5;
                } else {
                    bl2 = true;
                }
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result = bl2;
            return ConstantExpressionEvaluator.createCompileTimeConstant$default(this, result, expectedType, false, false, 12);
        }
        return this.evaluateCall(expression, expression.getOperationReference(), leftExpression, expectedType);
    }

    private final CompileTimeConstant<? extends Object> evaluateCall(@JetValueParameter(name="fullExpression") JetExpression fullExpression, @JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        ResolvedCall resolvedCall = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, callExpression);
        boolean bl = true;
        if (resolvedCall != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object d = resolvedCall.getResultingDescriptor();
        Name resultingDescriptorName = d != null ? d.getName() : null;
        boolean bl2 = true;
        if (resultingDescriptorName != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        boolean bl3 = true;
        if (argumentForReceiver != null) {
            bl3 = false;
        }
        if (bl3) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            Object result = this.evaluateUnaryAndCheck(argumentForReceiver, resultingDescriptorName.asString(), callExpression);
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createCompileTimeConstant(result, expectedType, !isNumberConversionMethod ? isArgumentPure : false, canBeUsedInAnnotation);
        }
        if (argumentsEntrySet.size() == 1) {
            Map.Entry canBeUsedInAnnotation = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)KotlinPackage.component1(canBeUsedInAnnotation);
            ResolvedValueArgument argument = (ResolvedValueArgument)KotlinPackage.component2(canBeUsedInAnnotation);
            OperationArgument argumentForParameter = null;
            argumentForParameter = this.createOperationArgumentForFirstParameter(argument, parameter);
            boolean bl4 = true;
            if (argumentForParameter != null) {
                bl4 = false;
            }
            if (bl4) {
                return null;
            }
            if (this.isDivisionByZero(resultingDescriptorName.asString(), argumentForParameter.getValue())) {
                return ErrorValue.create("Division by zero");
            }
            Object result = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, resultingDescriptorName.asString(), callExpression);
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) ? this.isPureConstant(argumentForParameter.getExpression()) : false;
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) ? this.canBeUsedInAnnotation(argumentForParameter.getExpression()) : false;
            EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation2, areArgumentsPure);
            Name name = resultingDescriptorName;
            return Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO) ? EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.createCompileTimeConstantForCompareTo(result, callExpression, c) : (Intrinsics.areEqual(name, OperatorConventions.EQUALS) ? EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.createCompileTimeConstantForEquals(result, callExpression, c) : this.createCompileTimeConstant(result, expectedType, areArgumentsPure, canBeUsedInAnnotation2));
        }
        return null;
    }

    private final boolean canBeUsedInAnnotation(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        Boolean bl = compileTimeConstant != null ? Boolean.valueOf(compileTimeConstant.canBeUsedInAnnotations()) : null;
        return bl != null ? bl : false;
    }

    private final boolean isPureConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        Boolean bl = compileTimeConstant != null ? Boolean.valueOf(compileTimeConstant.isPure()) : null;
        return bl != null ? bl : false;
    }

    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = EvaluatePackage-OperationsMapGenerated-a6f5ab90.getUnaryOperations().get(new UnaryOperationKey<Object>(receiver.getCtcType(), name));
        boolean bl = true;
        if (functions2 != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function = pair.component1();
        Function1<? super Long, ? extends Long> check = pair.component2();
        Object result = null;
        result = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, EvaluatePackage-OperationsMapGenerated-a6f5ab90.getEmptyUnaryFun())) {
            return result;
        }
        KotlinPackage.assert(EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        KotlinPackage.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result)) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return result;
    }

    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Object object2;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = EvaluatePackage-OperationsMapGenerated-a6f5ab90.getBinaryOperations().get(new BinaryOperationKey<Object, Object>(receiver.getCtcType(), parameter.getCtcType(), name));
        boolean bl = true;
        if (functions2 != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker = pair.component2();
        Object actualResult = null;
        try {
            object2 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception exception) {
            object2 = null;
        }
        actualResult = object2;
        if (Intrinsics.areEqual(checker, EvaluatePackage-OperationsMapGenerated-a6f5ab90.getEmptyBinaryFun())) {
            return actualResult;
        }
        KotlinPackage.assert(EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.isIntegerType(receiver.getValue()) ? EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.isIntegerType(parameter.getValue()) : false, ConstantExpressionEvaluator$evaluateBinaryAndCheck$1.instance$);
        object2 = ConstantExpressionEvaluator$evaluateBinaryAndCheck$2.instance$;
        BigInteger resultInBigIntegers = checker.invoke((BigInteger)((ConstantExpressionEvaluator$evaluateBinaryAndCheck$2)object2).invoke(receiver.getValue()), (BigInteger)((ConstantExpressionEvaluator$evaluateBinaryAndCheck$2)object2).invoke(parameter.getValue()));
        if (Intrinsics.areEqual(((ConstantExpressionEvaluator$evaluateBinaryAndCheck$2)object2).invoke(actualResult), resultInBigIntegers) ^ true) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.isIntegerType(parameter)) {
                Object object2 = parameter;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object2).longValue() == (long)0;
            }
            if (!(parameter instanceof Float) ? parameter instanceof Double : true) {
                Object object3 = parameter;
                if (object3 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object3).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitUnaryExpression"));
        }
        JetExpression leftExpression = expression.getBaseExpression();
        boolean bl = true;
        if (leftExpression != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        return this.evaluateCall(expression, expression.getOperationReference(), leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object callableDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        boolean bl = true;
        if (enumDescriptor == null) {
            bl = false;
        }
        if (bl ? DescriptorUtils.isEnumEntry(enumDescriptor) : false) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor? cannot be cast to org.jetbrains.jet.lang.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor);
        }
        ResolvedCall resolvedCall = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression);
        boolean bl2 = true;
        if (resolvedCall == null) {
            bl2 = false;
        }
        if (bl2 && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            Object object2;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.getBindingContext().get(BindingContext.COMPILE_TIME_INITIALIZER, callableDescriptor);
            boolean bl3 = true;
            if (compileTimeConstant != null) {
                bl3 = false;
            }
            if (bl3) {
                return null;
            }
            if (compileTimeConstant instanceof IntegerValueTypeConstant) {
                IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                JetType jetType = expectedType;
                if (jetType == null) {
                    jetType = TypeUtils.NO_EXPECTED_TYPE;
                }
                object2 = integerValueTypeConstant.getValue(jetType);
            } else {
                object2 = compileTimeConstant.getValue();
            }
            Object value = object2;
            return this.createCompileTimeConstant(value, expectedType, false, CompileTimeConstantUtils.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor));
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitQualifiedExpression"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression receiverExpression = expression.getReceiverExpression();
            return this.evaluateCall(expression, calleeExpression, receiverExpression, expectedType);
        }
        boolean bl = true;
        if (selectorExpression == null) {
            bl = false;
        }
        if (bl) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        ClassDescriptor classDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitCallExpression"));
        }
        ResolvedCall call = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        boolean bl = true;
        if (call != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        Object resultingDescriptor = call.getResultingDescriptor();
        boolean bl2 = true;
        if (resultingDescriptor != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            ValueParameterDescriptor valueParameterDescriptor = KotlinPackage.getFirst(resultingDescriptor.getValueParameters());
            JetType jetType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            JetType varargType = jetType;
            List<CompileTimeConstant<?>> arguments2 = KotlinPackage.flatMap((Iterable)call.getValueArguments().values(), (Function1)new ConstantExpressionEvaluator$visitCallExpression$arguments$1(this, varargType));
            JetType jetType2 = resultingDescriptor.getReturnType();
            if (jetType2 == null) {
                Intrinsics.throwNpe();
            }
            return new ArrayValue(arguments2, jetType2, true);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration())) {
            AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl();
            descriptor.setAnnotationType(classDescriptor.getDefaultType());
            AnnotationResolver.resolveAnnotationArgument(descriptor, call, this.trace);
            return new AnnotationValue(descriptor);
        }
        if (CompileTimeConstantUtils.isJavaClassMethodCall(call)) {
            JetType jetType = resultingDescriptor.getReturnType();
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return new JavaClassValue(jetType);
        }
        return null;
    }

    private final List<CompileTimeConstant<? extends Object>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = KotlinPackage.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            boolean bl = true;
            if (argumentExpression == null) {
                bl = false;
            }
            if (!bl) continue;
            CompileTimeConstant<? extends Object> compileTimeConstant = this.evaluate(argumentExpression, expectedType);
            boolean bl2 = true;
            if (compileTimeConstant == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitJetElement"));
        }
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<? extends CallableDescriptor> resolvedCall, @JetValueParameter(name="expression") JetExpression expression) {
        JetType receiverExpressionType = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.getReceiverExpressionType(resolvedCall);
        boolean bl = true;
        if (receiverExpressionType != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.getCompileTimeType(receiverExpressionType);
        boolean bl2 = true;
        if (receiverCompileTimeType != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.getCompileTimeType(parameter.getType());
        boolean bl = true;
        if (argumentCompileTimeType != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (KotlinPackage.getSize((Collection<? extends Object>)arguments2) != 1) {
            return null;
        }
        JetExpression argumentExpression = KotlinPackage.first(arguments2).getArgumentExpression();
        boolean bl2 = true;
        if (argumentExpression != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return this.createOperationArgument(argumentExpression, parameter.getType(), argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<? extends Object> compileTimeType) {
        CompileTimeConstant<? extends Object> evaluatedConstant = this.evaluate(expression, expressionType);
        boolean bl = true;
        if (evaluatedConstant != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        if (evaluatedConstant instanceof IntegerValueTypeConstant) {
            Number evaluationResultWithNewType = ((IntegerValueTypeConstant)evaluatedConstant).getValue(expressionType);
            return new OperationArgument(evaluationResultWithNewType, compileTimeType, expression);
        }
        Object evaluationResult = evaluatedConstant.getValue();
        boolean bl2 = true;
        if (evaluationResult != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    @Nullable
    public final CompileTimeConstant<? extends Object> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure, @JetValueParameter(name="canBeUsedInAnnotation") boolean canBeUsedInAnnotation) {
        JetType jetType;
        EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation, isPure);
        if (isPure) {
            jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
        } else {
            jetType = null;
        }
        return EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.createCompileTimeConstant(value, c, jetType);
    }

    /*
     * WARNING - void declaration
     */
    public static CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object2, JetType jetType, boolean bl, boolean bl2, int n) {
        int n2;
        int n3;
        void var5_7;
        if ((var5_7 & 4) != 0) {
            n3 = 1;
        }
        if ((var5_7 & 8) != 0) {
            n2 = 1;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object2, jetType, n3 != 0, n2 != 0);
    }

    @NotNull
    public final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "getTrace"));
        }
        return bindingTrace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new KObject(this){
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "evaluate"));
                }
                return (StringValue)entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitStringTemplateEntryWithExpression"));
                }
                JetExpression expression = entry.getExpression();
                boolean bl = true;
                if (expression != null) {
                    bl = false;
                }
                if (bl) {
                    return null;
                }
                return EvaluatePackage-ConstantExpressionEvaluator-65c28a8c.createStringConstant(ConstantExpressionEvaluator.evaluate$b$1(this.this$0, expression, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                StringValue stringValue = new StringValue(entry.getText(), true);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                return stringValue;
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                StringValue stringValue = new StringValue(entry.getUnescapedValue(), true);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                return stringValue;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator $init$b$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(trace);
        if (constantExpressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        return constantExpressionEvaluator;
    }

    @NotNull
    public static final /* synthetic */ List<CompileTimeConstant<? extends Object>> resolveArguments$b$2(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="valueArguments") @NotNull List<? extends ValueArgument> valueArguments, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        List<CompileTimeConstant<? extends Object>> list2 = $this.resolveArguments(valueArguments, expectedType);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        return list2;
    }

    @Nullable
    public static final /* synthetic */ CompileTimeConstant<? extends Object> evaluate$b$1(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "evaluate$b$1"));
        }
        return $this.evaluate(expression, expectedType);
    }

    @KotlinClass(abiVersion=14, data={"|\u0004)qCh\u00197bgNlsN\u00196fGRlcm\u001c:.\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:?\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u00016fi*!A.\u00198h\u0015!)g/\u00197vCR,'bA!os*11n\u001c;mS:T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u000fI,7o\u001c7wK*aQ\r\u001f9fGR,G\rV=qK*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(\"C2p]N$\u0018M\u001c;t\u0011\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)1\u0001b\u0002\t\b1\u0001QA\u0001C\u0002\u0011\u0017)1\u0001\"\u0003\t\u000b1\u0001QA\u0001C\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001QA\u0001C\u0002\u0011#)1\u0001\"\u0004\t\u00111\u0001QA\u0001C\u0006\u0011')1\u0001b\u0004\t\u00131\u0001QA\u0001C\b\u0011%)!\u0001\"\u0003\t\u000b\u0015\u0011A1\u0002E\u0007\u000b\t!i\u0001\u0003\u0005\u0005\u0007\ba1!\u0007\u0002\u0006\u0003!!QF\f\u0003\u00041\rij\u0001\u0002\u0001\t\n5\u0011Q!\u0001\u0005\u0006!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\rA\u001b\t!h\u0004\u0005\u0003!=QbA\u0003\u0002\u0011\u001da\t\u0001U\u0002\u0002C%)\u0011\u0001\u0003\u0005\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0011a\t\u0001$\u0001R\u0007%!1!C\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011'i\u0011\u0001\u0003\u00066\u0001\u0001"})
    public static final class object
    implements KObject {
        @Nullable
        public final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            ConstantExpressionEvaluator evaluator = ConstantExpressionEvaluator.$init$b$0(trace);
            return ConstantExpressionEvaluator.evaluate$b$1(evaluator, expression, expectedType);
        }

        public static CompileTimeConstant evaluate$default(object object2, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return object2.evaluate(jetExpression, bindingTrace, jetType);
        }

        private object() {
        }

        @NotNull
        public static final /* synthetic */ object $init$b$0() {
            object object2 = new object();
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "$init$b$0"));
            }
            return object2;
        }
    }

    @KotlinClass(abiVersion=14, data={"_\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT1A[3u\u0015\u0011a\u0017M\\4\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*1A(\u001b8jizRQA^1mk\u0016Tqa\u0019;d)f\u0004XMC\bD_6\u0004\u0018\u000e\\3US6,G+\u001f9f\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u000e\u0015\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007A\u001c\u0018N\u0003\u0003kCZ\f'BB(cU\u0016\u001cGO\u0003\u0006hKR\u001cEo\u0019+za\u0016TQbZ3u\u000bb\u0004(/Z:tS>t'\u0002C4fiZ\u000bG.^3k\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)!\u0001b\u0001\t\u0010\u0015\u0019A!\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001RA\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u0005!1QA\u0001\u0003\u0006\u0011\u001d!\u0011\u0001D\u0002\u001a\u0005\u0015\t\u0001\u0002B\u0017\u0016\t\u0001$\u00014B\u0011\t\u000b\u0005AI!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0005\u0019\u0003)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001c\u0004\u000e\u0007\u0011I\u0011\"\u0001E\b[=!\u0001\r\u0002M\u0007C\t)\u0011\u0001c\u0003V\u0007!)1\u0001\"\u0004\n\u0003!AQb\u0001C\n\u0013\u0005A\u0001\"L\b\u0005A\u0012AR!\t\u0002\u0006\u0003!!Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001\u0005\b\u001b\r!!\"C\u0001\t\u000fUnS\u0011\f\u0003d\u0002a%QT\u0002\u0003\u0001\u0011\u0015i!!B\u0001\t\tA\u001b\u0001!(\u0007\u0005\u0001!-Q\u0002C\u0003\u0002\u0011\u0013IQ\u0001\"\u0001\n\u0007\u0015\t\u0001\u0002\u0002G\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\fA\u001b\u0011!\t\u0002\u0006\u0003!\u0019\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!A\u0001"})
    private static final class OperationArgument
    implements KObject {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<? extends Object> ctcType;
        @NotNull
        private final JetExpression expression;

        @NotNull
        public final Object getValue() {
            Object object2 = this.value;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getValue"));
            }
            return object2;
        }

        @NotNull
        public final CompileTimeType<? extends Object> getCtcType() {
            CompileTimeType<? extends Object> compileTimeType = this.ctcType;
            if (compileTimeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getCtcType"));
            }
            return compileTimeType;
        }

        @NotNull
        public final JetExpression getExpression() {
            JetExpression jetExpression = this.expression;
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getExpression"));
            }
            return jetExpression;
        }

        @NotNull
        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<? extends Object> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (ctcType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctcType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

