/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;

public class Increment
extends IntrinsicMethod {
    private final int myDelta;

    public Increment(int delta) {
        this.myDelta = delta;
    }

    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType2, PsiElement element, List<JetExpression> arguments2, StackValue receiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        assert (AsmUtil.isPrimitive(returnType2)) : "Return type of Increment intrinsic should be of primitive type : " + returnType2;
        if (arguments2.size() > 0) {
            int index;
            JetExpression operand = arguments2.get(0);
            while (operand instanceof JetParenthesizedExpression) {
                operand = ((JetParenthesizedExpression)operand).getExpression();
            }
            if (operand instanceof JetReferenceExpression && returnType2 == Type.INT_TYPE && (index = codegen.indexOfLocal((JetReferenceExpression)operand)) >= 0) {
                StackValue.preIncrement(index, this.myDelta).put(returnType2, v);
                Type type = returnType2;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
                }
                return type;
            }
            StackValue value = codegen.genQualified(receiver, operand);
            value.dupReceiver(v);
            value.dupReceiver(v);
            value.put(returnType2, v);
            AsmUtil.genIncrement(returnType2, this.myDelta, v);
            value.store(returnType2, v);
            value.put(returnType2, v);
        } else {
            receiver.put(returnType2, v);
            AsmUtil.genIncrement(returnType2, this.myDelta, v);
        }
        Type type = returnType2;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/Increment", "generateImpl"));
        }
        return type;
    }
}

