/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.ParentCodegenAwareImpl;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public class SamWrapperCodegen
extends ParentCodegenAwareImpl {
    @NotNull
    private final JavaClassDescriptor samInterface;

    public SamWrapperCodegen(@NotNull GenerationState state, @NotNull JavaClassDescriptor samInterface, @Nullable MemberCodegen parentCodegen) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.samInterface = samInterface;
    }

    public Type genWrapper(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/SamWrapperCodegen", "genWrapper"));
        }
        Type asmType = Type.getObjectType(this.getWrapperName(file));
        JetType functionType = this.samInterface.getFunctionTypeForSamInterface();
        assert (functionType != null) : this.samInterface.toString();
        SimpleFunctionDescriptor interfaceFunction = SingleAbstractMethodUtils.getAbstractMethodOfSamInterface(this.samInterface);
        ClassBuilder cv = this.state.getFactory().newVisitor(asmType, file);
        cv.defineClass(file, 50, 16, asmType.getInternalName(), null, AsmTypeConstants.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samInterface).getInternalName()});
        cv.visitSource(file.getName(), null);
        Type functionAsmType = this.state.getTypeMapper().mapType(functionType);
        cv.newField(null, 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, interfaceFunction, functionType);
        cv.done();
        return asmType;
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(null, 0, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.invokespecial(AsmTypeConstants.OBJECT_TYPE.getInternalName(), "<init>", "()V");
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper", null);
        }
    }

    private void generateMethod(Type ownerType, Type functionType, ClassBuilder cv, SimpleFunctionDescriptor interfaceFunction, JetType functionJetType) {
        FunctionCodegen codegen = new FunctionCodegen(CodegenContext.STATIC, cv, this.state, this.getParentCodegen());
        FunctionDescriptor invokeFunction = functionJetType.getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false);
        codegen.genDelegate(interfaceFunction, invokeFunction, functionField);
    }

    private String getWrapperName(@NotNull JetFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/jet/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(JetPsiUtil.getFQName(containingFile));
        String packageInternalName = JvmClassName.byFqNameWithoutInnerClasses(packageClassFqName).getInternalName();
        return packageInternalName + "$sam$" + this.samInterface.getName().asString() + "$" + Integer.toHexString(CodegenUtil.getPathHashCode(containingFile.getVirtualFile()) * 31 + DescriptorUtils.getFqNameSafe(this.samInterface).hashCode());
    }
}

