/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleChunk {
    public static final ModuleChunk EMPTY = new ModuleChunk(Collections.<Module>emptyList());
    private final List<Module> modules;
    private final Map<File, Module> sourceFileToModule;

    public ModuleChunk(@NotNull List<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/jet/cli/jvm/compiler/ModuleChunk", "<init>"));
        }
        this.sourceFileToModule = Maps.newHashMap();
        this.modules = modules;
        for (Module module : modules) {
            for (String file : module.getSourceFiles()) {
                this.sourceFileToModule.put(new File(file).getAbsoluteFile(), module);
            }
        }
    }

    @NotNull
    public List<Module> getModules() {
        List<Module> list2 = this.modules;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/ModuleChunk", "getModules"));
        }
        return list2;
    }

    @Nullable
    public Module findModuleBySourceFile(@NotNull File sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jet/cli/jvm/compiler/ModuleChunk", "findModuleBySourceFile"));
        }
        return this.sourceFileToModule.get(sourceFile.getAbsoluteFile());
    }
}

