/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.js;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.OutputFileCollection;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.output.OutputDirector;
import org.jetbrains.jet.cli.common.output.SingleDirectoryDirector;
import org.jetbrains.jet.cli.common.output.outputUtils.OutputUtilsPackage;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.analyze.AnalyzerFacadeForJS;
import org.jetbrains.k2js.config.ClassPathLibraryDefintionsConfig;
import org.jetbrains.k2js.config.ClassPathLibrarySourcesLoader;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.config.LibrarySourcesConfig;
import org.jetbrains.k2js.facade.K2JSTranslator;
import org.jetbrains.k2js.facade.MainCallParameters;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createArguments() {
        K2JSCompilerArguments k2JSCompilerArguments = new K2JSCompilerArguments();
        if (k2JSCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "createArguments"));
        }
        return k2JSCompilerArguments;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
        }
        if (arguments2.sourceFiles == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify sources location via -sourceFiles", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, Arrays.asList(arguments2.sourceFiles));
        JetCoreEnvironment environmentForJS = JetCoreEnvironment.createForProduction(rootDisposable, configuration);
        Project project = environmentForJS.getProject();
        List<JetFile> sourcesFiles = environmentForJS.getSourceFiles();
        ClassPathLibrarySourcesLoader sourceLoader = new ClassPathLibrarySourcesLoader(project);
        List<JetFile> additionalSourceFiles = sourceLoader.findSourceFiles();
        sourcesFiles.addAll(additionalSourceFiles);
        if (arguments2.verbose) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector, sourcesFiles);
        }
        if (arguments2.outputFile == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputFile = new File(arguments2.outputFile);
        Config config = K2JSCompiler.getConfig(arguments2, project);
        if (K2JSCompiler.analyzeAndReportErrors(messageCollector, sourcesFiles, config)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputPrefixFile = null;
        if (arguments2.outputPrefix != null && !(outputPrefixFile = new File(arguments2.outputPrefix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.outputPrefix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputPostfixFile = null;
        if (arguments2.outputPostfix != null && !(outputPostfixFile = new File(arguments2.outputPostfix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.outputPostfix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.main);
        OutputFileCollection outputFiles = K2JSCompiler.translate(mainCallParameters, config, sourcesFiles, outputFile, outputPrefixFile, outputPostfixFile);
        SingleDirectoryDirector outputDirector = new SingleDirectoryDirector(outputFile.getParentFile());
        OutputUtilsPackage.writeAll(outputFiles, (OutputDirector)outputDirector, messageCollector);
        ExitCode exitCode = ExitCode.OK;
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "doExecute"));
        }
        return exitCode;
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector, @NotNull List<JetFile> sourceFiles) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        List<String> fileNames = ContainerUtil.map(sourceFiles, new Function<JetFile, String>(){

            @Override
            public String fun(@Nullable JetFile file) {
                assert (file != null);
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null) {
                    return FileUtil.toSystemIndependentName(virtualFile.getPath());
                }
                return file.getName() + "(no virtual file)";
            }
        });
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + Joiner.on(", ").join(fileNames), CompilerMessageLocation.NO_LOCATION);
    }

    private static OutputFileCollection translate(@NotNull MainCallParameters mainCall, @NotNull Config config, @NotNull List<JetFile> sourceFiles, @NotNull File outputFile, @Nullable File outputPrefix, @Nullable File outputPostfix) {
        if (mainCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCall", "org/jetbrains/jet/cli/js/K2JSCompiler", "translate"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/jet/cli/js/K2JSCompiler", "translate"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/cli/js/K2JSCompiler", "translate"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/jet/cli/js/K2JSCompiler", "translate"));
        }
        try {
            return K2JSTranslator.translateWithMainCallParameters(mainCall, sourceFiles, outputFile, outputPrefix, outputPostfix, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean analyzeAndReportErrors(@NotNull MessageCollector messageCollector, final @NotNull List<JetFile> sources, final @NotNull Config config) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "org/jetbrains/jet/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/jet/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector);
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            public AnalyzeExhaust invoke() {
                return AnalyzerFacadeForJS.analyzeFiles(sources, Predicates.<PsiFile>alwaysTrue(), config);
            }
        }, sources);
        return analyzerWithCompilerReport.hasErrors();
    }

    @NotNull
    private static Config getConfig(@NotNull K2JSCompilerArguments arguments2, @NotNull Project project) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/js/K2JSCompiler", "getConfig"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/cli/js/K2JSCompiler", "getConfig"));
        }
        if (arguments2.target != null) assert (arguments2.target == "v5") : "Unsupported ECMA version: " + arguments2.target;
        EcmaVersion ecmaVersion = EcmaVersion.defaultVersion();
        String moduleId = FileUtil.getNameWithoutExtension(new File(arguments2.outputFile));
        if (arguments2.libraryFiles != null) {
            LibrarySourcesConfig librarySourcesConfig = new LibrarySourcesConfig(project, moduleId, Arrays.asList(arguments2.libraryFiles), ecmaVersion, arguments2.sourcemap);
            if (librarySourcesConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "getConfig"));
            }
            return librarySourcesConfig;
        }
        ClassPathLibraryDefintionsConfig classPathLibraryDefintionsConfig = new ClassPathLibraryDefintionsConfig(project, moduleId, ecmaVersion, arguments2.sourcemap);
        if (classPathLibraryDefintionsConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/js/K2JSCompiler", "getConfig"));
        }
        return classPathLibraryDefintionsConfig;
    }

    public static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }
}

