/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard("overload.guard");
    public static final ThreadLocal<Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private int myApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        this(candidate, substitutor, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isApplicable() {
        return this.getApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        if (this.myArgumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), this.myArgumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        int level;
        if (this.myTypeArguments != null) {
            return this.getApplicabilityLevel();
        }
        if (this.myArgumentTypes == null) {
            return 1;
        }
        Integer boxedLevel = ourOverloadGuard.doPreventingRecursion(this.myArgumentList, false, new Computable<Integer>(){

            @Override
            public Integer compute() {
                PsiMethod method2 = MethodCandidateInfo.this.getElement();
                if (method2 != null && method2.hasTypeParameters() || MethodCandidateInfo.this.myArgumentList == null || !PsiUtil.isLanguageLevel8OrHigher(MethodCandidateInfo.this.myArgumentList)) {
                    return PsiUtil.getApplicabilityLevel(MethodCandidateInfo.this.getElement(), MethodCandidateInfo.this.getSubstitutor(false), MethodCandidateInfo.this.myArgumentTypes, MethodCandidateInfo.this.myLanguageLevel);
                }
                return MethodCandidateInfo.this.getApplicabilityLevelInner();
            }
        });
        int n = level = boxedLevel != null ? boxedLevel.intValue() : this.getApplicabilityLevel();
        if (level > 1 && !this.isTypeArgumentsApplicable(false)) {
            level = 1;
        }
        return level;
    }

    public PsiSubstitutor getSiteSubstitutor() {
        return super.getSubstitutor();
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor = this.myCalcedSubstitutor;
        if (substitutor == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method2 = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (!stackStamp.mayCacheNow() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
                    }
                    return psiSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method2.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = substitutor = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(false);
    }

    public boolean isTypeArgumentsApplicable(boolean includeReturnConstraint) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        PsiSubstitutor substitutor = this.getSubstitutor(includeReturnConstraint);
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor, this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : this.myArgumentList;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    public PsiMethod getElement() {
        return (PsiMethod)super.getElement();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments2) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/infos/MethodCandidateInfo", "inferSubstitutorFromArgs"));
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments2, true);
        }
        return this.typeArgumentsSubstitutor();
    }

    public PsiSubstitutor typeArgumentsSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        PsiMethod method2 = this.getElement();
        if (method2 != null) {
            PsiTypeParameter[] typeParams = method2.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        return incompleteSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, @NotNull PsiExpression[] arguments2, boolean includeReturnConstraint) {
        PsiClass containingClass;
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = new ConcurrentWeakHashMap<PsiElement, Pair<PsiMethod, PsiSubstitutor>>();
            CURRENT_CANDIDATE.set(map);
        }
        PsiMethod method2 = this.getElement();
        Pair<PsiMethod, PsiSubstitutor> alreadyThere = includeReturnConstraint ? map.put(this.getMarkerList(), Pair.create(method2, super.getSubstitutor())) : null;
        PsiTypeParameter[] typeParameters = method2.getTypeParameters();
        if (!method2.hasModifierProperty("static") && (containingClass = method2.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor)) {
            Project project = containingClass.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            PsiSubstitutor psiSubstitutor = javaPsiFacade.getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters);
            PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
            if (psiSubstitutor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
            }
            return psiSubstitutor2;
        }
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiSubstitutor project = PsiSubstitutor.EMPTY;
            PsiSubstitutor psiSubstitutor = project;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        Project project = method2.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
        PsiSubstitutor psiSubstitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method2.getParameterList().getParameters(), arguments2, this.mySubstitutor, parent, policy, this.myLanguageLevel);
        PsiSubstitutor psiSubstitutor3 = psiSubstitutor;
        if (psiSubstitutor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor3;
        finally {
            if (alreadyThere == null) {
                map.remove(this.getMarkerList());
            }
        }
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static Pair<PsiMethod, PsiSubstitutor> getCurrentMethod(PsiElement context) {
        Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> currentMethodCandidates = CURRENT_CANDIDATE.get();
        if (currentMethodCandidates != null && (pair = currentMethodCandidates.get(context)) != null) {
            currentMethodCandidates.put(context, Pair.create(pair.first, newSubstitutor));
        }
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }
}

