/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSuperMethodImplUtil");
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_KEY = PsiCacheKey.create("SIGNATURES_KEY", new NotNullFunction<PsiClass, Map<MethodSignature, HierarchicalMethodSignature>>(){

        @Override
        @NotNull
        public Map<MethodSignature, HierarchicalMethodSignature> fun(PsiClass dom) {
            Map map = PsiSuperMethodImplUtil.buildMethodHierarchy(dom, PsiSubstitutor.EMPTY, true, new THashSet(), false);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil$1", "fun"));
            }
            return map;
        }
    });

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method2) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method2, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method2, boolean checkAccess) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method2, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(PsiMethod method2, PsiClass parentClass) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method2, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(PsiMethod method2, PsiClass parentClass) {
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method2, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(PsiMethod method2, boolean checkAccess) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
            }
            return list2;
        }
        List<MethodSignatureBackedByPsiMethod> list3 = PsiSuperMethodImplUtil.findSuperMethodSignatures(method2, null, true);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list3;
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(PsiMethod method2, PsiClass parentClass, boolean allowStaticMethod) {
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search(method2, parentClass, true, allowStaticMethod).findAll());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(PsiMethod method2, boolean checkAccess, boolean allowStaticMethod) {
        if (method2.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method2.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method2.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method2.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(PsiMethod method2) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, true, false)) {
            return null;
        }
        return DeepestSuperMethodsSearch.search(method2).findFirst();
    }

    public static PsiMethod[] findDeepestSuperMethods(PsiMethod method2) {
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, true, false)) {
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection<PsiMethod> collection = DeepestSuperMethodsSearch.search(method2).findAll();
        return collection.toArray(new PsiMethod[collection.size()]);
    }

    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(PsiClass aClass, PsiSubstitutor substitutor, boolean includePrivates, Set<PsiClass> visited, boolean isInRawContext) {
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>();
        final THashMap<MethodSignature, SmartList<PsiMethod>> sameParameterErasureMethods = new THashMap<MethodSignature, SmartList<PsiMethod>>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashMap<MethodSignature, HierarchicalMethodSignatureImpl> map = new THashMap<MethodSignature, HierarchicalMethodSignatureImpl>(new TObjectHashingStrategy<MethodSignature>(){

            @Override
            public int computeHashCode(MethodSignature signature) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode(signature);
            }

            @Override
            public boolean equals(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals(o1, o2)) {
                    return false;
                }
                List list2 = (List)sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list2 != null && list2.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure(o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure(o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        for (PsiMethod method2 : aClass.getMethods()) {
            if (!method2.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)method2, "class.valid=" + aClass.isValid() + "; name=" + method2.getName());
            }
            if (!includePrivates && method2.hasModifierProperty("private")) continue;
            MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method2, substitutor, isInRawContext);
            HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(signature);
            SmartList<PsiMethod> list2 = (SmartList<PsiMethod>)sameParameterErasureMethods.get(signature);
            if (list2 == null) {
                list2 = new SmartList<PsiMethod>();
                sameParameterErasureMethods.put(signature, list2);
            }
            list2.add(method2);
            LOG.assertTrue(newH.getMethod().isValid());
            result.put(signature, newH);
            map.put(signature, newH);
        }
        for (PsiClassType superType : aClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult superTypeResolveResult = superType.resolveGenerics();
            PsiClass superClass = superTypeResolveResult.getElement();
            if (superClass == null || !visited.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = superTypeResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodImplUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor(superClass, superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, finalSubstitutor, false, visited, isInRawContextSuper);
            visited.remove(superClass);
            ArrayList<Pair<MethodSignature, HierarchicalMethodSignature>> flattened = new ArrayList<Pair<MethodSignature, HierarchicalMethodSignature>>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignature signature = entry.getKey();
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList<HierarchicalMethodSignature> supers = new ArrayList<HierarchicalMethodSignature>(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(new Pair<MethodSignature, HierarchicalMethodSignature>(signature, aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass, result, map, hms, signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass, result, map, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)entry.getValue();
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result.get(methodSignature) != null || !PsiUtil.isAccessible(aClass.getProject(), hierarchicalMethodSignature.getMethod(), aClass, aClass)) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result.put(methodSignature, hierarchicalMethodSignature);
        }
        return result;
    }

    private static void putInMap(PsiClass aClass, Map<MethodSignature, HierarchicalMethodSignature> result, Map<MethodSignature, HierarchicalMethodSignatureImpl> map, HierarchicalMethodSignature hierarchicalMethodSignature, MethodSignature signature) {
        if (!PsiUtil.isAccessible(aClass.getProject(), hierarchicalMethodSignature.getMethod(), aClass, aClass)) {
            return;
        }
        HierarchicalMethodSignatureImpl existing = map.get(signature);
        if (existing == null) {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy.getMethod().isValid());
            map.put(signature, copy);
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass, hierarchicalMethodSignature, existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            LOG.assertTrue(newSuper.getMethod().isValid());
            map.put(signature, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass, existing, hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result.containsKey(signature)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        if (thisSig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        if (thatSig == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable(thatRet, thisRet, false);
    }

    private static void mergeSupers(HierarchicalMethodSignatureImpl existing, HierarchicalMethodSignature superSignature) {
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    private static boolean isSuperMethod(PsiClass aClass, HierarchicalMethodSignature hierarchicalMethodSignature, HierarchicalMethodSignature superSignatureHierarchical) {
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiClass containingClass = hierarchicalMethodSignature.getMethod().getContainingClass();
        if (!superMethod.isConstructor() && !aClass.equals(superClass) && PsiUtil.isAccessible(aClass.getProject(), superMethod, aClass, aClass) && MethodSignatureUtil.isSubsignature(superSignatureHierarchical, hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("static")) {
                    return false;
                }
                if (superMethod.hasModifierProperty("default") || hierarchicalMethodSignature.getMethod().hasModifierProperty("default")) {
                    return !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true);
                }
                return true;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    return false;
                }
                if (!aClass.isInterface() && !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static HierarchicalMethodSignatureImpl copy(HierarchicalMethodSignature hi) {
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl(hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        return hierarchicalMethodSignature;
    }

    private static PsiSubstitutor obtainFinalSubstitutor(PsiClass superClass, PsiSubstitutor superSubstitutor, PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(new PsiTypeParameter[typeParams.size()]));
        }
        THashMap<PsiTypeParameter, PsiType> map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new THashMap<PsiTypeParameter, PsiType>();
            }
            map.put(typeParameter, t);
        }
        return map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance(superClass.getProject()).getElementFactory().createSubstitutor(map);
    }

    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(PsiClass aClass) {
        Map<MethodSignature, HierarchicalMethodSignature> map = PsiSuperMethodImplUtil.getSignaturesMap(aClass);
        return map.values();
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(final PsiMethod method2) {
        HierarchicalMethodSignature hierarchicalMethodSignature = CachedValuesManager.getCachedValue(method2, new CachedValueProvider<HierarchicalMethodSignature>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<HierarchicalMethodSignature> compute() {
                PsiClass aClass = method2.getContainingClass();
                HierarchicalMethodSignature result = null;
                if (aClass != null) {
                    result = (HierarchicalMethodSignature)PsiSuperMethodImplUtil.getSignaturesMap(aClass).get(method2.getSignature(PsiSubstitutor.EMPTY));
                }
                if (result == null) {
                    result = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)method2.getSignature(PsiSubstitutor.EMPTY));
                }
                return CachedValueProvider.Result.create(result, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        });
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(PsiClass aClass) {
        return SIGNATURES_KEY.getValue(aClass);
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method2, @NotNull Processor<PsiMethod> superMethodProcessor) {
        PsiClassType directSuper;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClassType[] directSupers;
        HierarchicalMethodSignature signature;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        if (superMethodProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_KEY.getCachedValueOrNull(aClass);
        if (cachedMap != null && (signature = cachedMap.get(method2.getSignature(PsiSubstitutor.EMPTY))) != null) {
            List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process(superSignature.getMethod())) continue;
                return false;
            }
            return true;
        }
        PsiClassType[] arr$ = directSupers = aClass.getSuperTypes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (resolveResult = (directSuper = arr$[i$]).resolveGenerics()).getSubstitutor() == PsiSubstitutor.EMPTY; ++i$) {
            PsiMethod[] candidates;
            PsiClass directSuperClass = resolveResult.getElement();
            if (directSuperClass == null) continue;
            for (PsiMethod candidate : candidates = directSuperClass.findMethodsBySignature(method2, false)) {
                if (!PsiUtil.canBeOverriden(candidate) || superMethodProcessor.process(candidate)) continue;
                return false;
            }
            return true;
        }
        List<HierarchicalMethodSignature> superSignatures = method2.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            if (superMethodProcessor.process(superSignature.getMethod())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethodSmart(@NotNull PsiMethod method2, @NotNull PsiMethod superMethod) {
        HierarchicalMethodSignature signature;
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (method2 == superMethod) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        PsiClass superClass = superMethod.getContainingClass();
        if (aClass == null || superClass == null || superClass == aClass) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method2, true, false)) {
            return false;
        }
        PsiMethod[] superMethods = null;
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_KEY.getCachedValueOrNull(aClass);
        if (cachedMap != null && (signature = cachedMap.get(method2.getSignature(PsiSubstitutor.EMPTY))) != null) {
            superMethods = MethodSignatureUtil.convertMethodSignaturesToMethods(signature.getSuperSignatures());
        }
        if (superMethods == null) {
            PsiClassType[] directSupers = aClass.getSuperTypes();
            ArrayList<PsiMethod> found = null;
            boolean canceled = false;
            for (PsiClassType directSuper : directSupers) {
                PsiMethod[] candidates;
                PsiClassType.ClassResolveResult resolveResult = directSuper.resolveGenerics();
                if (resolveResult.getSubstitutor() != PsiSubstitutor.EMPTY) {
                    canceled = true;
                    break;
                }
                PsiClass directSuperClass = resolveResult.getElement();
                if (directSuperClass == null || (candidates = directSuperClass.findMethodsBySignature(method2, false)).length == 0) continue;
                if (found == null) {
                    found = new ArrayList<PsiMethod>();
                }
                for (PsiMethod candidate : candidates) {
                    if (!PsiUtil.canBeOverriden(candidate)) continue;
                    found.add(candidate);
                }
            }
            PsiMethod[] psiMethodArray = canceled ? null : (superMethods = found == null ? PsiMethod.EMPTY_ARRAY : found.toArray(new PsiMethod[found.size()]));
        }
        if (superMethods == null) {
            superMethods = MethodSignatureUtil.convertMethodSignaturesToMethods(method2.getHierarchicalMethodSignature().getSuperSignatures());
        }
        for (PsiMethod superCandidate : superMethods) {
            if (!superMethod.equals(superCandidate) && !PsiSuperMethodImplUtil.isSuperMethodSmart(superCandidate, superMethod)) continue;
            return true;
        }
        return false;
    }
}

