/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private PsiClass myArrayClass;
    private PsiClass myArrayClass15;
    private final ConcurrentHashMap<GlobalSearchScope, PsiClassType> myCachedObjectType = new ConcurrentHashMap();
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCatchBlock(builder);
        }
    };

    public PsiElementFactoryImpl(PsiManagerEx manager) {
        super(manager);
        manager.registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                PsiElementFactoryImpl.this.myCachedObjectType.clear();
            }
        });
    }

    @Override
    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClass"));
        }
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            if (this.myArrayClass == null) {
                String body = "public class __Array__{\n public final int length;\n public Object clone() {}\n}";
                this.myArrayClass = ((PsiExtensibleClass)this.createClassFromText("public class __Array__{\n public final int length;\n public Object clone() {}\n}", null)).getOwnInnerClasses().get(0);
            }
            PsiClass psiClass = this.myArrayClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClass"));
            }
            return psiClass;
        }
        if (this.myArrayClass15 == null) {
            String body = "public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}";
            this.myArrayClass15 = ((PsiExtensibleClass)this.createClassFromText("public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}", null)).getOwnInnerClasses().get(0);
        }
        PsiClass psiClass = this.myArrayClass15;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClass"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor, languageLevel);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor, languageLevel, annotations);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createClass"));
        }
        PsiClass psiClass = this.createClassInner("class", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createClass"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createInterface"));
        }
        PsiClass psiClass = this.createClassInner("interface", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createInterface"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createEnum"));
        }
        PsiClass psiClass = this.createClassInner("enum", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createEnum"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationType"));
        }
        PsiClass psiClass = this.createClassInner("@interface", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationType"));
        }
        return psiClass;
    }

    private PsiClass createClassInner(@NonNls String type, @NonNls String name) {
        PsiUtil.checkIsIdentifier(this.myManager, name);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type + " " + name + " { }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type + " name \"" + name + "\".");
        }
        return classes2[0];
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeElement"));
        }
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated(element.getNode(), true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeElement"));
        }
        return lightTypeElement;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
        }
        if (type instanceof PsiClassReferenceType) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiClassReferenceType)type).getReference();
            if (psiJavaCodeReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
            }
            return psiJavaCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass refClass = resolveResult.getElement();
        assert (refClass != null) : type;
        LightClassReference lightClassReference = new LightClassReference(this.myManager, type.getCanonicalText(), refClass, resolveResult.getSubstitutor());
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        PsiTypeParameterList psiTypeParameterList = parameterList;
        if (psiTypeParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterList"));
        }
        return psiTypeParameterList;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameter(String name, PsiClassType[] superTypes) {
        PsiTypeParameter psiTypeParameter;
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type : superTypes) {
                if (type.equalsToText("java.lang.Object")) continue;
                builder.append(type.getCanonicalText()).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder.toString());
        }
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameter"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text = "class _Dummy_ { private " + type.getCanonicalText() + " " + name + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text);
        }
        PsiClass psiClass = classes2[0];
        PsiField[] fields2 = psiClass.getFields();
        if (fields2.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text);
        }
        PsiField field = fields2[0];
        field = (PsiField)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(field);
        PsiField psiField = (PsiField)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(field);
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType2) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(returnType2)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = returnType2.getCanonicalText();
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name + "() {} }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod[] methods2 = classes2[0].getMethods();
        if (methods2.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod method2 = methods2[0];
        method2 = (PsiMethod)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(method2);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method2);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod = this.createConstructor("_Dummy_");
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name + " { public " + name + "() {} }");
        PsiMethod method2 = aFile.getClasses()[0].getMethods()[0];
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method2);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return psiMethod;
    }

    @Override
    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return this.createMethodFromText(name + "() {}", context);
    }

    @Override
    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        PsiClassInitializer psiClassInitializer = (PsiClassInitializer)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(classInitializer);
        if (psiClassInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createClassInitializer"));
        }
        return psiClassInitializer;
    }

    @Override
    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text = type.getCanonicalText() + " " + name;
        PsiParameter parameter = this.createParameterFromText(text, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.myManager.getProject());
        PsiUtil.setModifierProperty(parameter, "final", JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated(parameter);
        parameter = (PsiParameter)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(parameter);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat(parameter);
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        return psiParameter;
    }

    @Override
    public PsiParameter createParameter(@NotNull @NonNls String name, PsiType type, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        PsiMethod psiMethod = this.createMethodFromText("void f(" + type.getCanonicalText() + " " + name + ") {}", context);
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        return parameters[0];
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(block);
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlock"));
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor(aClass));
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        if (classReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(classReference, null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters) {
        if (baseSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiElement createDummyHolder(@NotNull String text, @NotNull IElementType type, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, context);
        FileElement holder = result.getTreeElement();
        Language language = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text;
        PsiElement psiElement = psi;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(map);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPrimitiveType"));
        }
        return PsiJavaParserFacadeImpl.getPrimitiveType(text);
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope(this.myManager.getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        if ("java.lang.Object".equals(qName)) {
            PsiClassType cachedObjectType = this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                PsiClassType psiClassType = cachedObjectType;
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
                }
                return psiClassType;
            }
            PsiClass aClass = JavaPsiFacade.getInstance(this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass != null) {
                cachedObjectType = new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
                PsiClassType psiClassType = cachedObjectType = this.myCachedObjectType.cacheOrGet(resolveScope, cachedObjectType);
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
                }
                return psiClassType;
            }
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createClassReferenceElement"));
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReference lightClassReference = new LightClassReference(this.myManager, text, aClass);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createClassReferenceElement"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        String shortName = PsiNameHelper.getShortClassName(qName);
        LightClassReference lightClassReference = new LightClassReference(this.myManager, shortName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, qName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, aPackage);
        if (lightPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageStatement"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile("package " + name + ";");
        PsiPackageStatement stmt = aFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageStatement"));
        }
        return psiPackageStatement;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStaticStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        return psiImportStaticStatement;
    }

    @Override
    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText()).append(' ').append(names[i]);
        }
        builder.append(");");
        PsiParameterList psiParameterList = this.createMethodFromText(builder.toString(), null).getParameterList();
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceList"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        PsiReferenceList psiReferenceList = this.createMethodFromText(builder.toString(), null).getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceList"));
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, packageName);
        if (lightPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReferenceExpression lightClassReferenceExpression = new LightClassReferenceExpression(this.myManager, text, aClass);
        if (lightClassReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        return lightClassReferenceExpression;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReferenceExpression lightPackageReferenceExpression = new LightPackageReferenceExpression(this.myManager, aPackage);
        if (lightPackageReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        return lightPackageReferenceExpression;
    }

    @Override
    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createIdentifier"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, text);
        LightIdentifier lightIdentifier = new LightIdentifier(this.myManager, text);
        if (lightIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createIdentifier"));
        }
        return lightIdentifier;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isKeyword(text)) {
            throw new IncorrectOperationException("\"" + text + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, text);
        if (lightKeyword == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull @NonNls String keyword, PsiElement context) throws IncorrectOperationException {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        if (!JavaLexer.isKeyword(keyword, PsiUtil.getLanguageLevel(context))) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, keyword);
        if (lightKeyword == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatement"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass.getQualifiedName() + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatement"));
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatementOnDemand"));
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatementOnDemand"));
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        if (!this.isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text = "X " + name + (initializer != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text, null);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace(variable.getTypeElement(), this.createTypeElement(type), text);
        boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty(variable, "final", generateFinalLocals);
        if (initializer != null) {
            PsiElementFactoryImpl.replace(variable.getInitializer(), initializer, text);
        }
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        return psiDeclarationStatement;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message) {
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "replace"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiElementFactoryImpl", "replace"));
        }
        assert (original != null) : message;
        original.replace(replacement);
    }

    @Override
    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParamTag"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(builder.toString());
        if (psiDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParamTag"));
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationFromText"));
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated(psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationFromText"));
        }
        return psiAnnotation2;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlockFromText"));
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlockFromText"));
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createExpressionFromText"));
        }
        PsiExpression expression = super.createExpressionFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(expression);
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createExpressionFromText"));
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createFieldFromText"));
        }
        PsiField psiField = super.createFieldFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createFieldFromText"));
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterFromText"));
        }
        PsiParameter parameter = super.createParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(parameter);
        PsiParameter psiParameter = parameter;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterFromText"));
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createStatementFromText"));
        }
        PsiStatement statement = super.createStatementFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createStatementFromText"));
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeFromText"));
        }
        PsiType psiType = this.createTypeInner(text, context, true);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeFromText"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterFromText"));
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterFromText"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createMethodFromText"));
        }
        PsiMethod method2 = super.createMethodFromText(text, context, level);
        GeneratedMarkerVisitor.markGenerated(method2);
        PsiMethod psiMethod = method2;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStatementBase[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        PsiImportStatementBase[] psiImportStatementBaseArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @Override
    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        if (exceptionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text = "catch (" + exceptionType.getCanonicalText() + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CATCH_SECTION, PsiElementFactoryImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text + "'. Parsed element: " + element);
        }
        Project project = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated(catchSection);
        PsiCatchSection psiCatchSection = catchSection;
        if (psiCatchSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        return psiCatchSection;
    }

    @Override
    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isValidClassName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isValidMethodName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isValidParameterName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isValidFieldName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isValidLocalVariableName"));
        }
        return this.isIdentifier(name);
    }

    private boolean isIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiElementFactoryImpl", "isIdentifier"));
        }
        return PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(name);
    }
}

