/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class EqualsIntrinsic
implements BinaryOperationIntrinsic {
    @Override
    public boolean isApplicable(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "isApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "isApplicable"));
        }
        if (!OperatorConventions.EQUALS_OPERATIONS.contains(PsiUtils.getOperationToken(expression))) {
            return false;
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null);
        return JsDescriptorUtils.isBuiltin(functionDescriptor);
    }

    @Override
    @NotNull
    public JsExpression apply(@NotNull JetBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
        }
        boolean isNegated = PsiUtils.getOperationToken(expression).equals(JetTokens.EXCLEQ);
        if (right == JsLiteral.NULL || left == JsLiteral.NULL) {
            JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(right == JsLiteral.NULL ? left : right, isNegated);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
            }
            return jsBinaryOperation;
        }
        if (EqualsIntrinsic.canUseSimpleEquals(expression, context)) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(isNegated ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ, left, right);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
            }
            return jsBinaryOperation;
        }
        JsExpression result = TopLevelFIF.EQUALS.apply(left, Arrays.asList(right), context);
        JsExpression jsExpression = isNegated ? JsAstUtils.negated(result) : result;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "apply"));
        }
        return jsExpression;
    }

    private static boolean canUseSimpleEquals(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "canUseSimpleEquals"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/operation/EqualsIntrinsic", "canUseSimpleEquals"));
        }
        JetExpression left = expression.getLeft();
        assert (left != null) : "No left-hand side: " + expression.getText();
        Name typeName = JsDescriptorUtils.getNameIfStandardType(left, context);
        return typeName != null && NamePredicate.PRIMITIVE_NUMBERS.apply(typeName);
    }
}

