/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DefineInvocation;
import org.jetbrains.k2js.translate.declaration.PackageTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;

public final class PackageDeclarationTranslator
extends AbstractTranslator {
    private final Iterable<JetFile> files;
    private final Map<PackageFragmentDescriptor, PackageTranslator> packageFragmentToTranslator;

    public static List<JsStatement> translateFiles(@NotNull Collection<JetFile> files, @NotNull TranslationContext context) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "translateFiles"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "translateFiles"));
        }
        return new PackageDeclarationTranslator(files, context).translate();
    }

    private PackageDeclarationTranslator(@NotNull Iterable<JetFile> files, @NotNull TranslationContext context) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "<init>"));
        }
        super(context);
        this.packageFragmentToTranslator = new LinkedHashMap<PackageFragmentDescriptor, PackageTranslator>();
        this.files = files;
    }

    @NotNull
    private List<JsStatement> translate() {
        THashMap<FqName, DefineInvocation> packageFqNameToDefineInvocation = new THashMap<FqName, DefineInvocation>();
        for (JetFile file : this.files) {
            PackageFragmentDescriptor packageFragment = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
            PackageTranslator translator = this.packageFragmentToTranslator.get(packageFragment);
            if (translator == null) {
                this.createRootPackageDefineInvocationIfNeeded(packageFqNameToDefineInvocation);
                translator = PackageTranslator.create(packageFragment, this.context());
                this.packageFragmentToTranslator.put(packageFragment, translator);
            }
            translator.translate(file);
        }
        for (PackageTranslator translator : this.packageFragmentToTranslator.values()) {
            translator.add(packageFqNameToDefineInvocation);
        }
        JsVars vars = new JsVars(true);
        vars.addIfHasInitializer(this.getRootPackageDeclaration((DefineInvocation)packageFqNameToDefineInvocation.get(FqName.ROOT)));
        List<JsStatement> list2 = Collections.singletonList(vars);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "translate"));
        }
        return list2;
    }

    private void createRootPackageDefineInvocationIfNeeded(@NotNull Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        if (packageFqNameToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqNameToDefineInvocation", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "createRootPackageDefineInvocationIfNeeded"));
        }
        if (!packageFqNameToDefineInvocation.containsKey(FqName.ROOT)) {
            packageFqNameToDefineInvocation.put(FqName.ROOT, DefineInvocation.create(FqName.ROOT, null, new JsObjectLiteral(true), this.context()));
        }
    }

    private JsVars.JsVar getRootPackageDeclaration(@NotNull DefineInvocation defineInvocation) {
        if (defineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defineInvocation", "org/jetbrains/k2js/translate/declaration/PackageDeclarationTranslator", "getRootPackageDeclaration"));
        }
        JsInvocation rootPackageVar = new JsInvocation(this.context().namer().rootPackageDefinitionMethodReference(), defineInvocation.asList());
        return new JsVars.JsVar(this.context().scope().declareName(Namer.getRootPackageName()), rootPackageVar);
    }
}

