/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.storage;

import com.google.common.collect.ImmutableMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import jet.Function0;
import jet.Function1;
import jet.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.storage.LazyResolveStorageManager;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.NullableLazyValue;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class LockBasedLazyResolveStorageManager
implements LazyResolveStorageManager {
    private final LockBasedStorageManager storageManager;

    public LockBasedLazyResolveStorageManager(@NotNull LockBasedStorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "<init>"));
        }
        this.storageManager = storageManager;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createWeaklyRetainedMemoizedFunction(@NotNull Function1<K, V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createWeaklyRetainedMemoizedFunction"));
        }
        MemoizedFunctionToNotNull<K, V> memoizedFunctionToNotNull = this.storageManager.createMemoizedFunction(compute, new ConcurrentWeakValueHashMap());
        if (memoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createWeaklyRetainedMemoizedFunction"));
        }
        return memoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createWeaklyRetainedMemoizedFunctionWithNullableValues(@NotNull Function1<K, V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createWeaklyRetainedMemoizedFunctionWithNullableValues"));
        }
        MemoizedFunctionToNullable<K, V> memoizedFunctionToNullable = this.storageManager.createMemoizedFunctionWithNullableValues(compute, new ConcurrentWeakValueHashMap());
        if (memoizedFunctionToNullable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createWeaklyRetainedMemoizedFunctionWithNullableValues"));
        }
        return memoizedFunctionToNullable;
    }

    @Override
    @NotNull
    public BindingTrace createSafeTrace(@NotNull BindingTrace originalTrace) {
        if (originalTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalTrace", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createSafeTrace"));
        }
        LockProtectedTrace lockProtectedTrace = new LockProtectedTrace(this.storageManager.lock, originalTrace);
        if (lockProtectedTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createSafeTrace"));
        }
        return lockProtectedTrace;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createMemoizedFunction"));
        }
        MemoizedFunctionToNotNull<? super K, ? extends V> memoizedFunctionToNotNull = this.storageManager.createMemoizedFunction(compute);
        if (memoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createMemoizedFunction"));
        }
        return memoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        MemoizedFunctionToNullable<? super K, ? extends V> memoizedFunctionToNullable = this.storageManager.createMemoizedFunctionWithNullableValues(compute);
        if (memoizedFunctionToNullable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return memoizedFunctionToNullable;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createLazyValue"));
        }
        NotNullLazyValue<? extends T> notNullLazyValue = this.storageManager.createLazyValue(computable);
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createLazyValue"));
        }
        return notNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, @NotNull T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createRecursionTolerantLazyValue"));
        }
        if (onRecursiveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onRecursiveCall", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createRecursionTolerantLazyValue"));
        }
        NotNullLazyValue<? extends T> notNullLazyValue = this.storageManager.createRecursionTolerantLazyValue(computable, onRecursiveCall);
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createRecursionTolerantLazyValue"));
        }
        return notNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, @Nullable Function1<? super Boolean, ? extends T> onRecursiveCall, @NotNull Function1<? super T, ? extends Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createLazyValueWithPostCompute"));
        }
        NotNullLazyValue<? super T> notNullLazyValue = this.storageManager.createLazyValueWithPostCompute(computable, onRecursiveCall, postCompute);
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createLazyValueWithPostCompute"));
        }
        return notNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createNullableLazyValue"));
        }
        NullableLazyValue<? extends T> nullableLazyValue = this.storageManager.createNullableLazyValue(computable);
        if (nullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createNullableLazyValue"));
        }
        return nullableLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<? extends T> computable, T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        NullableLazyValue<? extends T> nullableLazyValue = this.storageManager.createRecursionTolerantNullableLazyValue(computable, onRecursiveCall);
        if (nullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        return nullableLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, @NotNull Function1<? super T, ? extends Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        NullableLazyValue<? super T> nullableLazyValue = this.storageManager.createNullableLazyValueWithPostCompute(computable, postCompute);
        if (nullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        return nullableLazyValue;
    }

    @Override
    public <T> T compute(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager", "compute"));
        }
        return this.storageManager.compute(computable);
    }

    private static class LockProtectedTrace
    implements BindingTrace {
        private final Lock lock;
        private final BindingTrace trace;
        private final BindingContext context;

        public LockProtectedTrace(@NotNull Lock lock, @NotNull BindingTrace trace) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "<init>"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "<init>"));
            }
            this.lock = lock;
            this.trace = trace;
            this.context = new LockProtectedContext(lock, trace.getBindingContext());
        }

        @Override
        @NotNull
        public BindingContext getBindingContext() {
            BindingContext bindingContext = this.context;
            if (bindingContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "getBindingContext"));
            }
            return bindingContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            this.lock.lock();
            try {
                this.trace.record(slice, key, value);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            this.lock.lock();
            try {
                this.trace.record(slice, key);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            this.lock.lock();
            try {
                V v = this.trace.get(slice, key);
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            this.lock.lock();
            Collection<K> collection = this.trace.getKeys(slice);
            Collection<K> collection2 = collection;
            if (collection2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "getKeys"));
            }
            return collection2;
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "report"));
            }
            this.lock.lock();
            try {
                this.trace.report(diagnostic);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class LockProtectedContext
    implements BindingContext {
        private final Lock lock;
        private final BindingContext context;

        private LockProtectedContext(Lock lock, BindingContext context) {
            this.lock = lock;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            this.lock.lock();
            Diagnostics diagnostics = this.context.getDiagnostics();
            Diagnostics diagnostics2 = diagnostics;
            if (diagnostics2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getDiagnostics"));
            }
            return diagnostics2;
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            this.lock.lock();
            try {
                V v = this.context.get(slice, key);
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            this.lock.lock();
            Collection<K> collection = this.context.getKeys(slice);
            Collection<K> collection2 = collection;
            if (collection2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getKeys"));
            }
            return collection2;
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            if (slice == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getSliceContents"));
            }
            this.lock.lock();
            ImmutableMap<K, V> immutableMap = this.context.getSliceContents(slice);
            ImmutableMap<K, V> immutableMap2 = immutableMap;
            if (immutableMap2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getSliceContents"));
            }
            return immutableMap2;
            finally {
                this.lock.unlock();
            }
        }
    }
}

