/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class InnerClassesScopeWrapper
extends AbstractScopeAdapter {
    private static final Predicate<Object> IS_CLASS = Predicates.instanceOf(ClassDescriptor.class);
    private final JetScope actualScope;

    public InnerClassesScopeWrapper(@NotNull JetScope actualScope) {
        if (actualScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualScope", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "<init>"));
        }
        this.actualScope = actualScope;
    }

    @Override
    @NotNull
    protected JetScope getWorkerScope() {
        JetScope jetScope = this.actualScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getWorkerScope"));
        }
        return jetScope;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getClassifier"));
        }
        ClassifierDescriptor classifier2 = this.actualScope.getClassifier(name);
        return IS_CLASS.apply(classifier2) ? classifier2 : null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getDeclarationsByLabel"));
        }
        Collection<Object> collection = Collections2.filter(this.actualScope.getDeclarationsByLabel(labelName), IS_CLASS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getDeclarationsByLabel"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<Object> collection = Collections2.filter(this.actualScope.getAllDescriptors(), IS_CLASS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getImplicitReceiversHierarchy"));
        }
        return list2;
    }

    public String toString() {
        return "Classes from " + this.actualScope;
    }
}

