/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.name.Name;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Map<JvmClassName, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private int version = -1;
    @Nullable
    private String[] annotationData = null;
    @Nullable
    private KotlinClassHeader.Kind headerKind = null;

    private ReadKotlinClassHeaderAnnotationVisitor() {
    }

    @Nullable
    public static KotlinClassHeader read(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "read"));
        }
        ReadKotlinClassHeaderAnnotationVisitor visitor = new ReadKotlinClassHeaderAnnotationVisitor();
        kotlinClass.loadClassAnnotations(visitor);
        return visitor.createHeader();
    }

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new KotlinClassHeader(KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION, this.version, null);
        }
        if ((this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.PACKAGE_FACADE) && this.annotationData == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.version, this.annotationData);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(annotationClassName);
        if (newKind == null) {
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        this.headerKind = newKind;
        if (newKind == KotlinClassHeader.Kind.CLASS || newKind == KotlinClassHeader.Kind.PACKAGE_FACADE) {
            return this.kotlinClassOrPackageVisitor(annotationClassName);
        }
        if (newKind == KotlinClassHeader.Kind.PACKAGE_FRAGMENT || newKind == KotlinClassHeader.Kind.TRAIT_IMPL) {
            return this.annotationWithAbiVersionVisitor(annotationClassName);
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinClassOrPackageVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitArray"));
                }
                if (name.asString().equals("data")) {
                    return this.stringArrayVisitor();
                }
                if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                    throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + annotationClassName);
                }
                return null;
            }

            @NotNull
            private KotlinJvmBinaryClass.AnnotationArgumentVisitor stringArrayVisitor() {
                final ArrayList strings = new ArrayList(1);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

                    @Override
                    public void visit(@Nullable Name name, @Nullable Object value) {
                        if (!(value instanceof String)) {
                            throw new IllegalStateException("Unexpected argument value: " + value);
                        }
                        strings.add((String)value);
                    }

                    @Override
                    public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumClassName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumEntryName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitArray"));
                        }
                        return ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    public void visitEnd() {
                        ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, strings.toArray(new String[strings.size()]));
                    }
                };
                if (annotationArgumentVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "stringArrayVisitor"));
                }
                return annotationArgumentVisitor;
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        return annotationArgumentVisitor;
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationWithAbiVersionVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "annotationWithAbiVersionVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitArray"));
                }
                return ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "annotationWithAbiVersionVisitor"));
        }
        return annotationArgumentVisitor;
    }

    private void visitIntValueForSupportedAnnotation(@Nullable Name name, @Nullable Object value, @NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitIntValueForSupportedAnnotation"));
        }
        if (name != null && name.asString().equals("abiVersion")) {
            this.version = value == null ? -1 : (Integer)value;
        } else {
            this.unexpectedArgument(name, className);
        }
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor unexpectedArgument(@Nullable Name name, @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "unexpectedArgument"));
        }
        if (AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            throw new IllegalStateException("Unexpected argument " + name + " for annotation " + annotationClassName);
        }
        return null;
    }

    static /* synthetic */ String[] access$302(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE_FRAGMENT), KotlinClassHeader.Kind.PACKAGE_FRAGMENT);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_TRAIT_IMPL), KotlinClassHeader.Kind.TRAIT_IMPL);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION), KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION), KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION);
    }
}

