/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public abstract class VirtualFileKotlinClassFinder
implements VirtualFileFinder {
    private final SLRUCache<VirtualFile, KotlinJvmBinaryClass> cache = new SLRUCache<VirtualFile, KotlinJvmBinaryClass>(2, 2){

        @Override
        @NotNull
        public KotlinJvmBinaryClass createValue(VirtualFile virtualFile) {
            VirtualFileKotlinClass virtualFileKotlinClass = new VirtualFileKotlinClass(new LockBasedStorageManager(), virtualFile);
            if (virtualFileKotlinClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder$1", "createValue"));
            }
            return virtualFileKotlinClass;
        }
    };

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "findKotlinClass"));
        }
        VirtualFile file = this.findVirtualFile(fqName);
        return file == null ? null : this.createKotlinClass(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public KotlinJvmBinaryClass createKotlinClass(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "createKotlinClass"));
        }
        SLRUCache<VirtualFile, KotlinJvmBinaryClass> sLRUCache = this.cache;
        // MONITORENTER : sLRUCache
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.cache.get(file);
        // MONITOREXIT : sLRUCache
        if (kotlinJvmBinaryClass != null) return kotlinJvmBinaryClass;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "createKotlinClass"));
    }
}

